package gov.va.med.term.hl7v3.propertyTypes;

import java.util.UUID;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Associations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.PropertyAssociation;

public class PT_Associations extends BPT_Associations
{
	public enum Attribute
	{
		SPECIALIZES_DOMAIN("specializes domain"),
		SPECIALIZED_BY_DOMAIN("specialized by domain");
		
		private PropertyAssociation property_;

		
		private Attribute(String niceName)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below during addProperty.
			property_ = new PropertyAssociation(null, niceName, null, null, niceName, false);
		}
		
		public PropertyAssociation getProperty()
		{
			return property_;
		}
		
		public UUID getUUID()
		{
			return property_.getUUID();
		}
	}

	public PT_Associations()
	{
		for (Attribute attr : Attribute.values())
		{
			addProperty(attr.getProperty());
		}
	}
}
