package gov.va.med.term.hl7v3.propertyTypes;

import java.util.UUID;
import gov.va.oia.terminology.converters.sharedUtils.IBDFCreationUtility;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Annotations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;
import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.api.component.concept.ConceptSpecification;
import gov.vha.isaac.ochre.api.component.sememe.version.dynamicSememe.DynamicSememeColumnInfo;
import gov.vha.isaac.ochre.api.component.sememe.version.dynamicSememe.DynamicSememeDataType;
import gov.vha.isaac.ochre.api.constants.DynamicSememeConstants;

public class PT_Annotations extends BPT_Annotations
{
	//These hacks are here, becuse maven is broken, and can't scan perfectly valid java code when this is inside an enumeration constructor.
	//sigh.
	private static String[] historyHackColNames = new String[] {"datetime", "responsible person name", "id", "is substantive change", 
			"is backward compatible change", "description"};
	private static DynamicSememeDataType[] historyHackColTypes = new DynamicSememeDataType[] {DynamicSememeDataType.STRING, DynamicSememeDataType.STRING, 
			DynamicSememeDataType.STRING, DynamicSememeDataType.BOOLEAN, DynamicSememeDataType.BOOLEAN, DynamicSememeDataType.STRING};
	
	private static String[] releasedVersionColNames = new String[] {"release date", "publisher version", "hl7 maintained indicator", 
			"complete codes indicator", "hl7 approved indicator"};
	private static DynamicSememeDataType[] releasedVersionColTypes = new DynamicSememeDataType[] {DynamicSememeDataType.STRING, DynamicSememeDataType.STRING, 
			DynamicSememeDataType.BOOLEAN, DynamicSememeDataType.BOOLEAN, DynamicSememeDataType.BOOLEAN};
	
	private static String[] supportedConceptPropertyColNames = new String[] {"property name", "type", "is mandatory indicator", "is apply to value sets indicator", 
			"default value"};
	private static DynamicSememeDataType[] supportedConceptPropertyColTypes = new DynamicSememeDataType[] {DynamicSememeDataType.NID, DynamicSememeDataType.NID, 
			DynamicSememeDataType.BOOLEAN, DynamicSememeDataType.BOOLEAN, DynamicSememeDataType.STRING};
	
	public enum Attribute
	{
		OID(MetaData.OID),
		
		VOCABULARY_MODEL("vocabulary model", "name", "title", "package kind", "definition kind", "schema version"),
		//The [] is a stupid hack I put in, to allow me to specify array of strings, rather than array, when setting up the dynamic sememe.
		PACKAGE_LOCATION("package location", "combined id", "root", "artifact", "[]realm namespace", "version"),
		RENDERING_INFORMATION("rendering information", "rendering time", "appliation"),
		LEGALESE("legalese", "copyright owner", "[]copyright years"),
		HISTORY_ITEM("history item",historyHackColNames, historyHackColTypes), 
		
		//some items for associations
		IS_NAVIGABLE("is navigable", DynamicSememeDataType.BOOLEAN),
		REFLEXIVITY("reflexivity", DynamicSememeDataType.NID),
		SYMMETRY("symmertry", DynamicSememeDataType.NID),
		TRANSITIVITY("transitivity", DynamicSememeDataType.NID),
		RELATIONSHIP_KIND("relationship kind", DynamicSememeDataType.NID),
		
		RELEASED_VERSION("released version", releasedVersionColNames, releasedVersionColTypes),
		SUPPORTED_CONCEPT_RELATIONSHIP("supported concept relationship", DynamicSememeDataType.NID),
		SUPPORTED_CONCEPT_PROPERTY("supported concept property", supportedConceptPropertyColNames, supportedConceptPropertyColTypes),
		
		//property type enum values
		SUPPORTED_CONCEPT_PROPERTY_TYPE("supported concept property type"),
		PROPERTY_DEFAULT_HANDLING_KIND("property default handling kind"),
		
		IS_SELECTABLE("is selectable", DynamicSememeDataType.BOOLEAN);
		

		private Property property_;
		private String[] orderedColumnNames_ = null;
		private DynamicSememeDataType[] orderedColumnTypes_ = null; 
		private String niceName_ = null;

		private Attribute(String niceName, String ... columnLabels )
		{
			// must build these later
			property_ = null;
			orderedColumnNames_ = columnLabels;
			niceName_ = niceName;
		}
		
		private Attribute(String niceName, DynamicSememeDataType type)
		{
			// must build these later
			property_ = null;
			niceName_ = niceName;
			orderedColumnTypes_ = new DynamicSememeDataType[] {type};
		}
		
		private Attribute(String niceName, String[] columnLabels, DynamicSememeDataType[] columnTypes)
		{
			// must build these later
			property_ = null;
			orderedColumnNames_ = columnLabels;
			orderedColumnTypes_ = columnTypes;
			niceName_ = niceName;
		}
		
		private Attribute(String niceName)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below during addProperty.
			property_ = new Property(null, niceName);
			niceName_ = niceName;
		}
		
		private Attribute(ConceptSpecification cs)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below, below during addProperty.
			property_ = new Property(null, cs);
			niceName_ = cs.getConceptDescriptionText();
		}

		public Property getProperty()
		{
			return property_;
		}
		
		public UUID getUUID()
		{
			return property_.getUUID();
		}
	}

	public PT_Annotations(IBDFCreationUtility importUtil)
	{
		for (Attribute attr : Attribute.values())
		{
			if (attr.getProperty() == null)
			{
				if (attr.orderedColumnNames_ != null)
				{
					attr.property_ = importUtil.createMultiColumnDynamicStringSememe(attr.niceName_, attr.orderedColumnNames_, attr.orderedColumnTypes_);
				}
				else if (attr.orderedColumnTypes_ != null && attr.orderedColumnTypes_.length == 1)
				{
					DynamicSememeColumnInfo[] cols = new DynamicSememeColumnInfo[1];
					cols[0] = new DynamicSememeColumnInfo(0, DynamicSememeConstants.get().DYNAMIC_SEMEME_COLUMN_VALUE.getPrimordialUuid(), 
							attr.orderedColumnTypes_[0], null, true, true);
					attr.property_ = new Property(null, attr.niceName_, null, null, false, Integer.MAX_VALUE, cols);
				}
			}
			addProperty(attr.getProperty());
		}
	}
}
