/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.cvx.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;

import org.apache.commons.io.input.XmlStreamReader;

import gov.va.med.term.cvx.data.CVXCodes;
import gov.va.med.term.cvx.data.ObjectFactory;

/**
 * 
 * {@link CVXReader}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class CVXReader {
	private final File file_;

	/**
	 * 
	 */
	public CVXReader(File inputFileOrDirectory) {
		if (inputFileOrDirectory.isDirectory())
		{
			ArrayList<File> files = new ArrayList<File>();
			for (File f : inputFileOrDirectory.listFiles())
			{
				if (f.isFile()
						&& (f.getName().toLowerCase().endsWith(".xml")))
				{
					files.add(f);
				}
			}
			
			if (files.size() != 1)
			{
				throw new RuntimeException(files.size() + " xml files were found inside of " + inputFileOrDirectory.getAbsolutePath() 
						+ " but this implementation requires 1 and only 1 xml file to be present.");
			}
			
			file_ = files.get(0);
		}
		else
		{
			file_ = inputFileOrDirectory;
		}

		System.out.println("Prepared to process: " + file_.getAbsolutePath());
	}

	public CVXCodes process() throws IOException, JAXBException {
		byte[] data = Files.readAllBytes(file_.toPath());
		ByteArrayInputStream xmlContentBytes = new ByteArrayInputStream (data);
		//XMLStreamReader xmlStreamReader = new DomStreamReader(file_);
		JAXBContext context = JAXBContext.newInstance(ObjectFactory.class);
		Unmarshaller unmarshaller = context.createUnmarshaller();
		//note: setting schema to null will turn validator off
		unmarshaller.setSchema(null);
		Object xmlObject = CVXCodes.class.cast(unmarshaller.unmarshal(xmlContentBytes));
		return (CVXCodes)xmlObject;
	}
}
