/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.cvx.propertyTypes;

import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Descriptions;

/**
 * 
 * {@link PT_Descriptions}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class PT_Descriptions extends BPT_Descriptions {
	public enum Descriptions {
		ShortDescription(FSN),
		FullVaccinename(SYNONYM);
		
		private final int descriptionType_;
		private Descriptions(int descriptionType) {
			descriptionType_= descriptionType;
		}
		public int getDescriptionType() { return descriptionType_; }
	}

	public PT_Descriptions()
	{
		super("CVX");

		for (Descriptions description : Descriptions.values()) {
			addProperty(description.name(), description.getDescriptionType());
		}
	}
}
