package gov.va.med.term.cvx.propertyTypes;

import gov.va.med.term.cvx.mojo.FieldsV1;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Annotations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.PropertyType;
import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.api.component.concept.ConceptSpecification;
import gov.vha.isaac.ochre.api.component.sememe.version.dynamicSememe.DynamicSememeColumnInfo;
import gov.vha.isaac.ochre.api.component.sememe.version.dynamicSememe.DynamicSememeDataType;
import gov.vha.isaac.ochre.api.constants.DynamicSememeConstants;

public class PT_Annotations extends BPT_Annotations
{
	public enum Attribute
	{
		CVXCode(MetaData.CODE),
		LastUpdated(FieldsV1.LastUpdated, DynamicSememeDataType.LONG),
		Status(FieldsV1.Status, DynamicSememeDataType.STRING);

		private final Property property_;
		private final String key_;

//		private Attribute(String niceName)
//		{
//			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
//			property_ = new Property(null, niceName);
//		}
		
		private Attribute(FieldsV1 annotationConceptFsnColumn, DynamicSememeDataType type) {
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			key_ = annotationConceptFsnColumn.toString();
			property_ = new Property(
					(PropertyType)null,
					annotationConceptFsnColumn.toString(),
					(String)null, (String) null,
					false, Integer.MAX_VALUE, 
					new DynamicSememeColumnInfo[] { new DynamicSememeColumnInfo(
							null,
							0,
							DynamicSememeConstants.get().DYNAMIC_SEMEME_COLUMN_VALUE.getUUID(),
							type,
							null, true, null, null, true) });
		}
		private Attribute(ConceptSpecification cs)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			key_ = cs.getConceptDescriptionText();
			property_ = new Property(null, cs);
		}

		public Property getProperty()
		{
			return property_;
		}
		
		public String getKey() { return key_; }
	}

	public PT_Annotations()
	{
		super("CVX");
		for (Attribute attr : Attribute.values())
		{
			addProperty(attr.getProperty());
		}
	}
}
