package gov.vha.isaac.term.cpt.mojo.propertyTypes;

import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Annotations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;
import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.api.component.concept.ConceptSpecification;

public class PT_Annotations extends BPT_Annotations
{
	public enum Attribute
	{
		Code(MetaData.CODE);

		private Property property_;

		private Attribute(ConceptSpecification cs)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			property_ = new Property(null, cs);
		}

		public Property getProperty()
		{
			return property_;
		}
	}

	public PT_Annotations()
	{
		super("CPT");
		for (Attribute attr : Attribute.values())
		{
			addProperty(attr.getProperty());
		}
	}
}
