/**
 * Copyright Notice
 * 
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.va.isaac.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import gov.vha.isaac.ochre.api.util.TaskCompleteCallback;

/**
 * Class for handling the ISAAC search functionality.
 * <p>
 * Logic has been mostly copied from LEGO {@code WBDataStore#search}, but now rewritten and updated to use the newer
 * search APIs provided in OTF
 * 
 * @author ocarlsen
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a>
 */
public class TaskHandler<PARAMS, RESULT>
{
	private static final Logger LOG = LoggerFactory.getLogger(TaskHandler.class);
	
	final Runnable task;
	
	public TaskHandler(Runnable task) {
		this.task = task;
	}
	
	public TaskHandle<RESULT> run(
			PARAMS taskParameters,   
			final TaskCompleteCallback<Object> callback, 
			final Integer taskId)
	{
		final TaskHandle<RESULT> handle = new TaskHandle<>();

		// Do search in background.
		Runnable r = new Runnable()
		{
			@Override
			public void run()
			{
				try
				{
					task.run();
				}
				catch (Exception ex)
				{
					LOG.error("Unexpected error during task execution", ex);
					handle.setError(ex);
				}
				callback.taskComplete(null, handle.getStartTime(), taskId);
			}
		};

		Utility.execute(r);
		return handle;
	}
}
