package gov.va.med.term.vhat.data.dto;

import java.util.ArrayList;
import java.util.List;

public abstract class NamedPropertiedItemImportDTO extends CodedImportDTO
{
	protected String name;
	private List<PropertyImportDTO> properties = new ArrayList<>();
	private List<RelationshipImportDTO> relationships = new ArrayList<>();
	
	public NamedPropertiedItemImportDTO(String action, String name, String code, Long vuid, boolean active)
	{
		super(action, code, vuid, active);
		this.name = name;
	}
	
	public String getName()
	{
		return name;
	}
	
	public List<PropertyImportDTO> getProperties()
	{
		return properties;
	}

	public List<RelationshipImportDTO> getRelationships()
	{
		return relationships;
	}
}
