/*
 * Created on Oct 18, 2004
 */

package gov.va.med.term.vhat.data.dto;

public class CodeSystem
{
	private String name;
	private Long vuid;
	private String description;
	private String copyright;
	private String copyrightURL;
	private String preferredDesignationType;
	private String action;
	private Version version;

	public CodeSystem(String name, Long vuid, String description, String copyright, String copyrightURL, String preferredDesignationType, String action)
	{
		this.name = name;
		this.vuid = vuid;
		this.description = description;
		this.copyright = copyright;
		this.copyrightURL = copyrightURL;
		this.action = action;
		this.preferredDesignationType = preferredDesignationType;
	}

	/**
	 * @return Returns the copyright.
	 */
	public String getCopyright()
	{
		return copyright;
	}

	/**
	 * @return the copyrightURL
	 */
	public String getCopyrightURL()
	{
		return copyrightURL;
	}

	/**
	 * @return Returns the description.
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * @return Returns the name.
	 */
	public String getName()
	{
		return name;
	}

	public String toString()
	{
		return this.getName();
	}

	public Long getVuid()
	{
		return vuid;
	}

	/**
	 * @return Returns the designationType
	 */
	public String getPreferredDesignationType()
	{
		return preferredDesignationType;
	}

	public Version getVersion()
	{
		return version;
	}

	public void setVersion(Version version)
	{
		this.version = version;
	}
	
	public String getAction()
	{
		return action;
	}
}
