/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.vha.isaac.rf2.convert.mojo;

import org.jvnet.hk2.annotations.Service;
import gov.va.oia.terminology.converters.sharedUtils.config.ConfigOptionsDescriptor;
import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.pombuilder.converter.ConverterOptionParam;
import gov.vha.isaac.ochre.pombuilder.converter.ConverterOptionParamSuggestedValue;

/**
 * 
 * {@link Rf2ConfigOptions}
 *
 * Descriptions of the conversion options that this converter expects, in a form that can be automatically 
 * converted to a json file to be published with the mojo, for easy consumption and eventual inclusion into the 
 * GUI.
 * 
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a>
 */
@Service
public class Rf2ConfigOptions implements ConfigOptionsDescriptor
{
	public ConverterOptionParam[] getConfigOptions() {
		return new ConverterOptionParam[] { 
				new ConverterOptionParam("Module UUID", "moduleUUID",
						"The UUID of the module to load this content on.  If not provided, defaults to the SNOMED CT Core Module", 
						true, 
						false,
						new ConverterOptionParamSuggestedValue(MetaData.SNOMED_CT_CORE_MODULE.getPrimordialUuid().toString(), 
								MetaData.SNOMED_CT_CORE_MODULE.getConceptDescriptionText()),
						new ConverterOptionParamSuggestedValue(MetaData.US_EXTENSION_MODULE.getPrimordialUuid().toString(),
								MetaData.US_EXTENSION_MODULE.getConceptDescriptionText())
				)};
	}

	@Override
	public String getName()
	{
		return "rf2-mojo";
	}
}
