/**
 * Copyright Notice
 * 
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * SctTreeItemDisplayPolicies
 * 
 * @author <a href="mailto:joel.kniaz@gmail.com">Joel Kniaz</a>
 */
package gov.va.isaac.interfaces.gui.views.commonFunctionality.taxonomyView;

import javafx.scene.Node;

/**
 * SctTreeItemDisplayPolicies
 * 
 * @author <a href="mailto:joel.kniaz@gmail.com">Joel Kniaz</a>
 *
 */
public interface SctTreeItemDisplayPolicies {	
	/**
	 * @param item the {@link SctTreeItemI} to be evaluated
	 * @return Node the FX graphical Node generated by the SctTreeItemDisplayPolicies as applied to the specified {@link SctTreeItemI}
	 */
	public Node computeGraphic(SctTreeItemI item);
	
	/**
	 * @param treeItem the {@link SctTreeItemI}, the visibility of which to evaluate
	 * @return boolean the boolean value indicating, according to these SctTreeItemDisplayPolicies, whether ({@code true}) or not ({@code false}) the specified {@link SctTreeItemI} should be displayed
	 */
	public default boolean shouldDisplay(SctTreeItemI treeItem) { return true; }
}
