#! /usr/bin/python
#
# Utility command to add a remote to all repositories
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://vadev.mantech.com darmbrust

import subprocess







projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme',
			'apache_extensions']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

remoteName = 'vadev'
remoteBaseURL = 'https://vadev.mantech.com:4848/git/r/'

for project in projects:
	print("==================================")
	print("Adding Remote to " + project)
	git("-C", project, "remote", "add", remoteName, remoteBaseURL + project + ".git", "-f", "--tags")
	git("-C", project, "remote", "-v")
	print("==================================")
	print("");