package gov.va.med.term.vhat.data.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MapEntryImportDTO extends EntityImportDTO
{
	private String sourceCode;
	private String targetCode;
	private int sequence;
	private Long grouping;
	private Date effectiveDate;
	private List<PropertyImportDTO> properties = new ArrayList<>();
	private List<RelationshipImportDTO> relationships = new ArrayList<>();
	private List<DesignationImportDTO> designations = new ArrayList<>();

	public MapEntryImportDTO(String action, Long vuid, boolean active, String sourceCode, String targetCode, int sequence, Long grouping, Date effectiveDate)
	{
		super(action, vuid, active);
		this.sourceCode = sourceCode;
		this.targetCode = targetCode;
		this.sequence = sequence;
		this.grouping = grouping;
		this.effectiveDate = effectiveDate;
	}

	public String getSourceCode()
	{
		return sourceCode;
	}

	public String getTargetCode()
	{
		return targetCode;
	}

	public int getSequence()
	{
		return sequence;
	}

	public Long getGrouping()
	{
		return grouping;
	}

	public Date getEffectiveDate()
	{
		return effectiveDate;
	}

	public List<PropertyImportDTO> getProperties()
	{
		return properties;
	}

	public List<RelationshipImportDTO> getRelationships()
	{
		return relationships;
	}

	public List<DesignationImportDTO> getDesignations()
	{
		return designations;
	}
}
