/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.vha.isaac.utils.file_transfer;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

/**
 * 
 * {@link FileTransferFutureTask}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class FileTransferFutureTask<V> extends FutureTask<V> {
	private final String description_;
	private Set<FileTransferFutureTask<V>> retryTasks_ = new HashSet<>();
	
	/**
	 * @param callable
	 */
	public FileTransferFutureTask(Callable<V> callable, String description) {
		super(callable);
		
		this.description_ = description;
	}

	/**
	 * @param callable
	 */
	public FileTransferFutureTask(Runnable callable, V result, String description) {
		super(callable, result);

		this.description_ = description;
	}

	public String getDescription() {
		return description_;
	}
	
	public Set<FileTransferFutureTask<V>> getRetryTasks() {
		return retryTasks_;
	}

	@SafeVarargs
	public final void setRetryTasks(FileTransferFutureTask<V>...retryTasks) {
		retryTasks_.clear();
		for (FileTransferFutureTask<V> task : retryTasks) {
			if (task == this || task.getRetryTasks().size() > 0) {
				throw new IllegalArgumentException("Can't add a retry task that is same as self or also has its own retries");
			}
			retryTasks_.add(task);
		}
	}
}
