/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.vha.isaac.utils.file_transfer;


import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;

public class ChecksumGenerator
{
	/**
	 * Accepts types like "MD5 or SHA1"
	 * @param data
	 * @return
	 */
	public static String calculateChecksum(String type, byte[] data)
	{
		try
		{
			MessageDigest md = MessageDigest.getInstance(type);
			DigestInputStream dis = new DigestInputStream(new ByteArrayInputStream(data), md);
			dis.read(data);
			return getStringValue(md);
		}
		catch (Exception e)
		{
			throw new RuntimeException("Unexpected error: " + e);
		}
	}
	
	public static String calculateChecksum(String type, File data) throws Exception {
		MessageDigest md = MessageDigest.getInstance(type);
		try (InputStream is = Files.newInputStream(data.toPath()))
		{
			DigestInputStream dis = new DigestInputStream(is, md);
			byte[] buffer = new byte[8192];
			
			int read = 0;
			while (read != -1)
			{
				read = dis.read(buffer);
			}
			return getStringValue(md);
		}
	}
	
	private static String getStringValue(MessageDigest md)
	{
		byte[] digest = md.digest();
		return new HexBinaryAdapter().marshal(digest).toLowerCase();
	}
}