# ISAAC-file-transfer-utils
Tools for copying maven artifacts from one repo to another

Downloads from specified repo URL to local filesystem (current directory)
or uploads from local file system (current directory) to specified repo URL

	-url {url}
		This option takes an argument which is interpreted as the remote URL, whether for download or upload.
		
	-cfg {config}
		This option takes a single argument which is interpreted as the local path to a JSON configuration file.

	-download|-upload
		These boolean flags, which take no arguments, specify, respectively, that files should be either downloaded or uploaded.

	-user {user}
		This option takes a single argument which is interpreted as the user name to be used in order to perform authentication.
	
	-password {password}
		This option takes a single argument which is interpreted as the password to be used in order to perform authentication.
		
	-stripSnapshotVersionDetails
		This boolean flag, which takes no argument, downloads and uploads snapshot versions of artifacts and changes the file names to contain only the version and not the timestamp and build number.  By default, the timestamp and build number are included in the snapshot file names.
		
	-sslVerify
		This boolean flag, which takes no argument, allows hostname verification for SSL to be performed.  By default, hostname verification for SSL is disabled.
		
	-overwrite
		This boolean flag, which takes no argument, forces overwrite of existing file on both upload and download.  By default, existing remote files will not be overwritten, and existing local files will not be overwritten as long as they pass SHA1 checksum verification.
		
	-ignoreChecksum
		This boolean flag, which takes no argument, specifies that an individual download should not fail if checksum verification fails.  By default, a download for a file that does not pass SHA1 checksum verification will be considered failed and any remnant of that file will be deleted.
		
Example arguments:
	
	Download RELEASE artifacts (given existing, populated repo https://vadev.mantech.com:8080/nexus/content/repositories/releases):
		java -jar isaac-file-transfer-utils-1.2.17-jar-with-dependencies.jar \
		-cfg file-transfer-software-release-full.cfg \
		-user devtest -password {password} \
		-url https://vadev.mantech.com:8080/nexus/content/repositories/releases \
		-download
		
	Upload RELEASE artifacts (given existing nexus repo "test-release-repository" and populated local filesystem in current directory):
		java -jar isaac-file-transfer-utils-1.2.17-jar-with-dependencies.jar \
		-cfg file-transfer-software-release-full.cfg \
		-user devtest -password {password} \
		-url https://DNS  cttdbs81.aac.DNS   :8443/nexus/content/repositories/releases/ \
		-upload
		
	Download SNAPSHOT artifacts (given existing, populated repo https://vadev.mantech.com:8080/nexus/content/repositories/snapshots):
		java -jar isaac-file-transfer-utils-1.2.17-jar-with-dependencies.jar \
		-cfg file-transfer-test-snapshot-small.cfg \
		-user devtest -password {password} \
		-url https://vadev.mantech.com:8080/nexus/content/repositories/snapshots \
		-download
		
	Upload SNAPSHOT artifacts (given existing nexus repo "test-snapshot-repository" and populated local filesystem in current directory):
		java -jar isaac-file-transfer-utils-1.2.17-jar-with-dependencies.jar \
		-cfg file-transfer-test-snapshot-small.cfg \
		-user devtest -password {password} \
		-url https://vadev.mantech.com:8080/nexus/content/repositories/test-snapshot-repository/snapshots \
		-upload