/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.vha.isaac.rest.utils;

import gov.vha.isaac.rest.api.exceptions.RestException;

/**
 * 
 * {@link RequestParameterUtils}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class RequestParameterUtils {
	private RequestParameterUtils() {
		// non-instantiable utility class
	}

	/**
	 * @param parameterName - name of parameter for purposes of error reporting
	 * @param integerStr - integer String
	 * @return
	 * @throws RestException
	 */
	public static int parseIntegerParameter(String parameterName, String integerStr) throws RestException {
		try {
			return Integer.parseInt(integerStr.trim().replaceAll(",", ""));
		} catch (Exception e) {
			throw new RestException(parameterName, integerStr, "invalid integer parameter value");
		}
	}
}
