package gov.vha.isaac.ochre.integration.tests;

import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvnet.testing.hk2testng.HK2;
import org.testng.Assert;
import org.testng.annotations.Test;

import gov.vha.isaac.ochre.access.maint.deployment.dto.PublishChecksumMessage;
import gov.vha.isaac.ochre.access.maint.deployment.dto.PublishChecksumMessageDTO;
import gov.vha.isaac.ochre.deployment.hapi.extension.hl7.message.ChecksumComposite;
import gov.vha.isaac.ochre.deployment.hapi.extension.hl7.message.ConstructChecksum;

/**
 * 
 */
@HK2("integration")
public class HL7Tests {
	private static final Logger LOG = LogManager.getLogger(HL7Tests.class);
	

	@Test (dependsOnGroups = {"vhat-xml"})
	public void testIsaacChecksumConstruction() {
		try {
			LOG.info("Test Isaac Checksum Construction HL7.");
			List<PublishChecksumMessage> list = new ArrayList<>();
			PublishChecksumMessage msg = new PublishChecksumMessageDTO(0, null, "5197546");	// Imm Admin Routes
			list.add(msg);
			msg = new PublishChecksumMessageDTO(0, null, "5197430");  // Imm Body Sites
			list.add(msg);
			msg = new PublishChecksumMessageDTO(0, null, "5197835");  // Imm Vaccine Information Statement
			list.add(msg);
			msg = new PublishChecksumMessageDTO(0, null, "4712063"); // Medication routes (child of Pharmacy)
			list.add(msg);
		
			List<ChecksumComposite> results = ConstructChecksum.checksum(list);
			
			// validate results
			Assert.assertEquals("2d431d804573e8ab18c099edd6378663", results.get(0).getChecksum());
			Assert.assertEquals("cc486567108bef209c48a5f9826c0558", results.get(1).getChecksum());
			Assert.assertEquals(4, results.size());
			Assert.assertEquals("5197546", results.get(0).getVuid());
		
		} catch (Exception e) {
			Assert.fail(e.getClass().getName(), e);
		} 
	}

	@Test (dependsOnGroups = {"vhat-xml"})	
	public void testConstructChecksumBadVuid() throws Exception {
		
		List<PublishChecksumMessage> list = new ArrayList<>();
		PublishChecksumMessage msg = new PublishChecksumMessageDTO(0, null, "9999999");	
		list.add(msg);
		
		try {
		  ConstructChecksum.checksum(list);
		  fail("This should throw an exception.");
		} catch(Exception e) {
			
		}
				
	}
	

}
