/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.vha.isaac.ochre.services.utility;

import java.security.MessageDigest;

import javax.xml.bind.DatatypeConverter;

/**
 * Calculate MD5 hash of given input string.
 * 
 * @author <a href="mailto:nmarques@westcoastinformatics.com">Nuno Marques</a>
 */
public class ChecksumCalculator
{
	
	/**
	 * Calculate MD5 hash of given input string.
	 * 
	 * @param checksumInput string to calculate MD5 hash.
	 * @return string - MD5 hash of checksumInput
	 * @throws Exception
	 */
	public static String compute(String checksumInput) throws Exception {

		MessageDigest md = MessageDigest.getInstance("MD5");
		md.update(checksumInput.toString().getBytes());
		byte[] digest = md.digest();

		return DatatypeConverter.printHexBinary(digest).toLowerCase();
	}
}
