package gov.vha.isaac.ochre.deployment.hapi.extension.hl7.message;


/**
 * For a given VUID subset, contains the checksum input and the computed checksum output.
 */
public class ChecksumComposite {

	/** The checksum input. */
	private String checksumInput;
	
	/** The checksum. */
	private String checksum;
	
	/** The vuid. */
	private String vuid;


	/**
	 * Instantiates a new checksum composite.
	 */
	public ChecksumComposite() {
		// do nothing
	}
	
	/**
	 * Instantiates a new checksum composite.
	 *
	 * @param checksumInput the checksum input
	 * @param checksum the checksum
	 * @param vuid the vuid
	 */
	public ChecksumComposite(String checksumInput, String checksum, String vuid) {
		super();
		this.checksumInput = checksumInput;
		this.checksum = checksum;
		this.vuid = vuid;
	}

	/**
	 * Gets the checksum input.
	 *
	 * @return the checksum input
	 */
	public String getChecksumInput() {
		return checksumInput;
	}

	/**
	 * Sets the checksum input.
	 *
	 * @param checksumInput the new checksum input
	 */
	public void setChecksumInput(String checksumInput) {
		this.checksumInput = checksumInput;
	}

	/**
	 * Gets the checksum.
	 *
	 * @return the checksum
	 */
	public String getChecksum() {
		return checksum;
	}

	/**
	 * Sets the checksum.
	 *
	 * @param checksum the new checksum
	 */
	public void setChecksum(String checksum) {
		this.checksum = checksum;
	}
	
	/**
	 * Gets the vuid.
	 *
	 * @return the vuid
	 */
	public String getVuid() {
		return vuid;
	}

	/**
	 * Sets the vuid.
	 *
	 * @param vuid the new vuid
	 */
	public void setVuid(String vuid) {
		this.vuid = vuid;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((checksum == null) ? 0 : checksum.hashCode());
		result = prime * result + ((checksumInput == null) ? 0 : checksumInput.hashCode());
		result = prime * result + ((vuid == null) ? 0 : vuid.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ChecksumComposite other = (ChecksumComposite) obj;
		if (checksum == null) {
			if (other.checksum != null)
				return false;
		} else if (!checksum.equals(other.checksum))
			return false;
		if (checksumInput == null) {
			if (other.checksumInput != null)
				return false;
		} else if (!checksumInput.equals(other.checksumInput))
			return false;
		if (vuid == null) {
			if (other.vuid != null)
				return false;
		} else if (!vuid.equals(other.vuid))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ChecksumComposite [checksumInput=" + checksumInput + ", checksum=" + checksum + ", vuid=" + vuid + "]";
	}


}
