#
#
#
# Generated by <a href="http://enunciate.webcohesion.com">Enunciate</a>.
#
require 'json'

# adding necessary json serialization methods to standard classes.
class Object
  def to_jaxb_json_hash
    return self
  end

  def self.from_json o
    return o
  end
end

class String
  def self.from_json o
    return o
  end
end

class Boolean
  def self.from_json o
    return o
  end
end

class Numeric
  def self.from_json o
    return o
  end
end

class Time
  #json time is represented as number of milliseconds since epoch
  def to_jaxb_json_hash
    return (to_i * 1000) + (usec / 1000)
  end

  def self.from_json o
    if o.nil?
      return nil
    else
      return Time.at(o / 1000, (o % 1000) * 1000)
    end
  end
end

class Array
  def to_jaxb_json_hash
    a = Array.new
    each { |_item| a.push _item.to_jaxb_json_hash }
    return a
  end
end

class Hash
  def to_jaxb_json_hash
    h = Hash.new
    each { |_key, _value| h[_key.to_jaxb_json_hash] = _value.to_jaxb_json_hash }
    return h
  end
end


module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Concept

              # (no documentation provided)
              class RestConceptChronology

                # The concept sequence identifier of this concept
                attr_accessor :conceptSequence
                # The &quot;best&quot; description for this concept.  This is selected based on the attributes within the session for
                # stamp and language coordinates - or - if none present - the server default.
                attr_accessor :description
                # The data that was not expanded as part of this call (but can be)
                attr_accessor :expandables
                # The identifier data for the object
                attr_accessor :identifiers
                # The list of concept versions.  Depending on the expand parameter, may be empty, the latest only, or all versions.
                attr_accessor :versions

                # the json hash for this RestConceptChronology
                def to_jaxb_json_hash
                  _h = {}
                  _h['conceptSequence'] = conceptSequence.to_jaxb_json_hash unless conceptSequence.nil?
                  _h['description'] = description.to_jaxb_json_hash unless description.nil?
                  _h['expandables'] = expandables.to_jaxb_json_hash unless expandables.nil?
                  _h['identifiers'] = identifiers.to_jaxb_json_hash unless identifiers.nil?
                  if !versions.nil?
                    _ha = Array.new
                    versions.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['versions'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestConceptChronology
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestConceptChronology with a json hash
                def init_jaxb_json_hash(_o)
                  @conceptSequence = Fixnum.from_json(_o['conceptSequence']) unless _o['conceptSequence'].nil?
                  @description = String.from_json(_o['description']) unless _o['description'].nil?
                  @expandables = Gov::Vha::Isaac::Rest::Api::Data::Expandables.from_json(_o['expandables']) unless _o['expandables'].nil?
                  @identifiers = Gov::Vha::Isaac::Rest::Api1::Data::RestIdentifiedObject.from_json(_o['identifiers']) unless _o['identifiers'].nil?
                  if !_o['versions'].nil?
                    @versions = Array.new
                    _oa = _o['versions']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @versions.push Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @versions.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestConceptChronology from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Concept

              # (no documentation provided)
              class RestConceptVersion

                # The data that was not expanded as part of this call (but can be)
                attr_accessor :expandables
                # The concept chronology for this concept.  Depending on the expand parameter, may be empty.
                attr_accessor :conChronology
                # The StampedVersion details for this version of this concept.
                attr_accessor :conVersion
                # A boolean indicating whether the concept is fully-defined or primitive.  true for fully-defined, false for primitive
                # This value is not populated / returned if the concept does not contain a logic graph from which to derive the information.
                attr_accessor :isConceptDefined
                # The parent concepts(s) of the concept at this point in time (&#39;is a&#39; relationships).  Depending on the expand parameter, this may not be returned.
                attr_accessor :parents
                # The child concepts(s) of the concept at this point in time (&#39;is a&#39; relationships).  Depending on the expand parameter, this may not be returned.
                attr_accessor :children
                # The number of child concept(s) of the concept at this point in time (&#39;is a&#39; relationships).  Depending on the expand parameter, this may not be returned.
                # This will not be returned if the children field is populated.
                attr_accessor :childCount
                # The number of parent concept(s) of the concept at this point in time (&#39;is a&#39; relationships).  Depending on the expand parameter, this may not be returned.
                # This will not be returned if the parents field is populated.
                attr_accessor :parentCount
                # The concept sequences of the sememe assemblage concepts that this concept is a member of (there exists a sememe instance where the referencedComponent
                # is this concept, and the assemblage is the value returned).  Note that this field is typically not populated - and when it is populated, it is only
                # in response to a request via the Taxonomy or Concept APIs, when the parameter &#39;sememeMembership=true&#39; is passed.
                # See more details on TaxonomyAPIs#getConceptVersionTaxonomy(String, String, int, String, int, String, String, String)
                attr_accessor :sememeMembership

                # the json hash for this RestConceptVersion
                def to_jaxb_json_hash
                  _h = {}
                  _h['expandables'] = expandables.to_jaxb_json_hash unless expandables.nil?
                  _h['conChronology'] = conChronology.to_jaxb_json_hash unless conChronology.nil?
                  _h['conVersion'] = conVersion.to_jaxb_json_hash unless conVersion.nil?
                  _h['isConceptDefined'] = isConceptDefined.to_jaxb_json_hash unless isConceptDefined.nil?
                  if !parents.nil?
                    _ha = Array.new
                    parents.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['parents'] = _ha
                  end
                  if !children.nil?
                    _ha = Array.new
                    children.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['children'] = _ha
                  end
                  _h['childCount'] = childCount.to_jaxb_json_hash unless childCount.nil?
                  _h['parentCount'] = parentCount.to_jaxb_json_hash unless parentCount.nil?
                  if !sememeMembership.nil?
                    _ha = Array.new
                    sememeMembership.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['sememeMembership'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestConceptVersion
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestConceptVersion with a json hash
                def init_jaxb_json_hash(_o)
                  @expandables = Gov::Vha::Isaac::Rest::Api::Data::Expandables.from_json(_o['expandables']) unless _o['expandables'].nil?
                  @conChronology = Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptChronology.from_json(_o['conChronology']) unless _o['conChronology'].nil?
                  @conVersion = Gov::Vha::Isaac::Rest::Api1::Data::RestStampedVersion.from_json(_o['conVersion']) unless _o['conVersion'].nil?
                  @isConceptDefined = Boolean.from_json(_o['isConceptDefined']) unless _o['isConceptDefined'].nil?
                  if !_o['parents'].nil?
                    @parents = Array.new
                    _oa = _o['parents']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @parents.push Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @parents.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                  if !_o['children'].nil?
                    @children = Array.new
                    _oa = _o['children']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @children.push Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @children.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                  @childCount = Fixnum.from_json(_o['childCount']) unless _o['childCount'].nil?
                  @parentCount = Fixnum.from_json(_o['parentCount']) unless _o['parentCount'].nil?
                  if !_o['sememeMembership'].nil?
                    @sememeMembership = Array.new
                    _oa = _o['sememeMembership']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @sememeMembership.push Fixnum.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @sememeMembership.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestConceptVersion from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Search

              # (no documentation provided)
              class RestSearchResult

                # The internal identifier of the sememe that matched the query
                attr_accessor :matchNid
                # The text of the description that matched the query (may be blank, if the description is not available/active on the path used to populate this)
                attr_accessor :matchText
                # The Lucene Score for this result.  This value is only useful for ranking search results relative to other search results within the SAME QUERY
                # execution.  It may not be used to rank one query against another.
                attr_accessor :score
                # Returns true if the sememe that matched the query is active (with the specified of default stamp,
                # false if inactive.
                attr_accessor :active
                # The data that was not expanded as part of this call (but can be)
                attr_accessor :expandables
                # The (optionally) populated identifiers (UUIDs) of the sememe that matched the query.  Must pass expand=&#39;uuid&#39; to have
                # this populated.
                attr_accessor :identifiers
                # The (optionally) populated concept that is referenced (indirectly) by the sememe that matched the query.  This is calculated by
                # looking up the sememe of the matchNid, and then getting the referenced component of that sememe.  If the referenced component
                # is a concept, that is the concept that is returned.  If the referenced component is a sememe, then the process is repeated (following
                # the referenced component reference of the sememe) - continuing until a concept is found.  If an (unusual) case occurs where the
                # sememe chain doesn&#39;t lead to a concept, this will not be populated.  This is populated by passing the expand parameter &#39;referencedConcept&#39;.
                # If this is passed, you may also (optionally) pass the parameters &#39;versionsLatestOnly&#39; or &#39;versionsAll&#39;
                attr_accessor :referencedConcept

                # the json hash for this RestSearchResult
                def to_jaxb_json_hash
                  _h = {}
                  _h['matchNid'] = matchNid.to_jaxb_json_hash unless matchNid.nil?
                  _h['matchText'] = matchText.to_jaxb_json_hash unless matchText.nil?
                  _h['score'] = score.to_jaxb_json_hash unless score.nil?
                  _h['active'] = active.to_jaxb_json_hash unless active.nil?
                  _h['expandables'] = expandables.to_jaxb_json_hash unless expandables.nil?
                  _h['identifiers'] = identifiers.to_jaxb_json_hash unless identifiers.nil?
                  _h['referencedConcept'] = referencedConcept.to_jaxb_json_hash unless referencedConcept.nil?
                  return _h
                end

                # the json (string form) for this RestSearchResult
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestSearchResult with a json hash
                def init_jaxb_json_hash(_o)
                  @matchNid = Fixnum.from_json(_o['matchNid']) unless _o['matchNid'].nil?
                  @matchText = String.from_json(_o['matchText']) unless _o['matchText'].nil?
                  @score = Float.from_json(_o['score']) unless _o['score'].nil?
                  @active = Boolean.from_json(_o['active']) unless _o['active'].nil?
                  @expandables = Gov::Vha::Isaac::Rest::Api::Data::Expandables.from_json(_o['expandables']) unless _o['expandables'].nil?
                  @identifiers = Gov::Vha::Isaac::Rest::Api1::Data::RestIdentifiedObject.from_json(_o['identifiers']) unless _o['identifiers'].nil?
                  @referencedConcept = Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptChronology.from_json(_o['referencedConcept']) unless _o['referencedConcept'].nil?
                end

                # constructs a RestSearchResult from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Coordinate

              # (no documentation provided)
              class RestLogicCoordinate

                # (no documentation provided)
                attr_accessor :statedAssemblage
                # (no documentation provided)
                attr_accessor :inferredAssemblage
                # (no documentation provided)
                attr_accessor :descriptionLogicProfile
                # (no documentation provided)
                attr_accessor :classifier

                # the json hash for this RestLogicCoordinate
                def to_jaxb_json_hash
                  _h = {}
                  _h['statedAssemblage'] = statedAssemblage.to_jaxb_json_hash unless statedAssemblage.nil?
                  _h['inferredAssemblage'] = inferredAssemblage.to_jaxb_json_hash unless inferredAssemblage.nil?
                  _h['descriptionLogicProfile'] = descriptionLogicProfile.to_jaxb_json_hash unless descriptionLogicProfile.nil?
                  _h['classifier'] = classifier.to_jaxb_json_hash unless classifier.nil?
                  return _h
                end

                # the json (string form) for this RestLogicCoordinate
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestLogicCoordinate with a json hash
                def init_jaxb_json_hash(_o)
                  @statedAssemblage = Fixnum.from_json(_o['statedAssemblage']) unless _o['statedAssemblage'].nil?
                  @inferredAssemblage = Fixnum.from_json(_o['inferredAssemblage']) unless _o['inferredAssemblage'].nil?
                  @descriptionLogicProfile = Fixnum.from_json(_o['descriptionLogicProfile']) unless _o['descriptionLogicProfile'].nil?
                  @classifier = Fixnum.from_json(_o['classifier']) unless _o['classifier'].nil?
                end

                # constructs a RestLogicCoordinate from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Coordinate

              # (no documentation provided)
              class RestTaxonomyCoordinate

                # (no documentation provided)
                attr_accessor :stated
                # (no documentation provided)
                attr_accessor :stampCoordinate
                # (no documentation provided)
                attr_accessor :languageCoordinate
                # (no documentation provided)
                attr_accessor :logicCoordinate

                # the json hash for this RestTaxonomyCoordinate
                def to_jaxb_json_hash
                  _h = {}
                  _h['stated'] = stated.to_jaxb_json_hash unless stated.nil?
                  _h['stampCoordinate'] = stampCoordinate.to_jaxb_json_hash unless stampCoordinate.nil?
                  _h['languageCoordinate'] = languageCoordinate.to_jaxb_json_hash unless languageCoordinate.nil?
                  _h['logicCoordinate'] = logicCoordinate.to_jaxb_json_hash unless logicCoordinate.nil?
                  return _h
                end

                # the json (string form) for this RestTaxonomyCoordinate
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestTaxonomyCoordinate with a json hash
                def init_jaxb_json_hash(_o)
                  @stated = Boolean.from_json(_o['stated']) unless _o['stated'].nil?
                  @stampCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestStampCoordinate.from_json(_o['stampCoordinate']) unless _o['stampCoordinate'].nil?
                  @languageCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestLanguageCoordinate.from_json(_o['languageCoordinate']) unless _o['languageCoordinate'].nil?
                  @logicCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestLogicCoordinate.from_json(_o['logicCoordinate']) unless _o['logicCoordinate'].nil?
                end

                # constructs a RestTaxonomyCoordinate from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api

          module Data

            # (no documentation provided)
            class Pagination

              # Link to retrieve previous result set page
              attr_accessor :previousUrl
              # Link to retrieve next result set page
              attr_accessor :nextUrl
              # The page (of maximum size pageSize) number from beginning of dataset starting at 1
              attr_accessor :pageNum
              # Estimated size of set of all matching values of which the current page is a subset. Value is negative if and only if unknown. May be affected by filtering.
              attr_accessor :approximateTotal

              # the json hash for this Pagination
              def to_jaxb_json_hash
                _h = {}
                _h['previousUrl'] = previousUrl.to_jaxb_json_hash unless previousUrl.nil?
                _h['nextUrl'] = nextUrl.to_jaxb_json_hash unless nextUrl.nil?
                _h['pageNum'] = pageNum.to_jaxb_json_hash unless pageNum.nil?
                _h['approximateTotal'] = approximateTotal.to_jaxb_json_hash unless approximateTotal.nil?
                return _h
              end

              # the json (string form) for this Pagination
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this Pagination with a json hash
              def init_jaxb_json_hash(_o)
                @previousUrl = String.from_json(_o['previousUrl']) unless _o['previousUrl'].nil?
                @nextUrl = String.from_json(_o['nextUrl']) unless _o['nextUrl'].nil?
                @pageNum = Fixnum.from_json(_o['pageNum']) unless _o['pageNum'].nil?
                @approximateTotal = Fixnum.from_json(_o['approximateTotal']) unless _o['approximateTotal'].nil?
              end

              # constructs a Pagination from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            # (no documentation provided)
            class RestCoordinatesToken

              # Serialized coordinates token
              attr_accessor :token

              # the json hash for this RestCoordinatesToken
              def to_jaxb_json_hash
                _h = {}
                _h['token'] = token.to_jaxb_json_hash unless token.nil?
                return _h
              end

              # the json (string form) for this RestCoordinatesToken
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this RestCoordinatesToken with a json hash
              def init_jaxb_json_hash(_o)
                @token = String.from_json(_o['token']) unless _o['token'].nil?
              end

              # constructs a RestCoordinatesToken from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            # (no documentation provided)
            class RestId

              # The id value
              attr_accessor :value
              # The id type
              attr_accessor :idType

              # the json hash for this RestId
              def to_jaxb_json_hash
                _h = {}
                _h['value'] = value.to_jaxb_json_hash unless value.nil?
                _h['idType'] = idType.to_jaxb_json_hash unless idType.nil?
                return _h
              end

              # the json (string form) for this RestId
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this RestId with a json hash
              def init_jaxb_json_hash(_o)
                @value = String.from_json(_o['value']) unless _o['value'].nil?
                @idType = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestSupportedIdType.from_json(_o['idType']) unless _o['idType'].nil?
              end

              # constructs a RestId from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api

          module Data

            # (no documentation provided)
            class Expandable

              # The name of the item that is expandable (pass this to have this value expanded directly by the call that produced this)
              attr_accessor :name
              # The url to call to get the expanded item separately
              attr_accessor :url

              # the json hash for this Expandable
              def to_jaxb_json_hash
                _h = {}
                _h['name'] = name.to_jaxb_json_hash unless name.nil?
                _h['url'] = url.to_jaxb_json_hash unless url.nil?
                return _h
              end

              # the json (string form) for this Expandable
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this Expandable with a json hash
              def init_jaxb_json_hash(_o)
                @name = String.from_json(_o['name']) unless _o['name'].nil?
                @url = String.from_json(_o['url']) unless _o['url'].nil?
              end

              # constructs a Expandable from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestSememeVersion

                # The data that was not expanded as part of this call (but can be)
                attr_accessor :expandables
                # The sememe chronology for this concept.  Depending on the expand parameter, may be empty.
                attr_accessor :sememeChronology
                # The StampedVersion details for this version of this sememe.
                attr_accessor :sememeVersion
                # The nested sememes attached to this sememe.  Not populated by default, include expand=nested to expand these.
                attr_accessor :nestedSememes

                # the json hash for this RestSememeVersion
                def to_jaxb_json_hash
                  _h = {}
                  _h['expandables'] = expandables.to_jaxb_json_hash unless expandables.nil?
                  _h['sememeChronology'] = sememeChronology.to_jaxb_json_hash unless sememeChronology.nil?
                  _h['sememeVersion'] = sememeVersion.to_jaxb_json_hash unless sememeVersion.nil?
                  if !nestedSememes.nil?
                    _ha = Array.new
                    nestedSememes.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['nestedSememes'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestSememeVersion
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestSememeVersion with a json hash
                def init_jaxb_json_hash(_o)
                  @expandables = Gov::Vha::Isaac::Rest::Api::Data::Expandables.from_json(_o['expandables']) unless _o['expandables'].nil?
                  @sememeChronology = Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestSememeChronology.from_json(_o['sememeChronology']) unless _o['sememeChronology'].nil?
                  @sememeVersion = Gov::Vha::Isaac::Rest::Api1::Data::RestStampedVersion.from_json(_o['sememeVersion']) unless _o['sememeVersion'].nil?
                  if !_o['nestedSememes'].nil?
                    @nestedSememes = Array.new
                    _oa = _o['nestedSememes']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @nestedSememes.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @nestedSememes.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSememeVersion from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            # (no documentation provided)
            class RestSystemInfo

              # The full version number of this API.  Note, this is an array, because in the future
              # the API may simultaneously support versions such as [1.3, 2.0] for reverse compatibility.
              #
              # The agreement with Komet is that we do &quot;Major.Minor.Revision&quot;
              # The Major version only changes in concert with the rest API paths changing from /1/ to /2/ for example.
              # The Minor version is changed whenever we change a previously existing API or data structure - such that it
              # may break existing code in KOMET.  Note, you can add new APIs / properties to existing data structures without
              # breaking KOMET.
              # The Revision is changed whenever we make a change that modifies the API, but only in a way that won&#39;t impact
              # existing KOMET functionality - such as adding a new API, adding a new data structure, adding a field to an existing
              # data structure.
              attr_accessor :supportedAPIVersions
              # REST API Implementation Version - aka the version number of the software running here.
              attr_accessor :apiImplementationVersion
              # The version number of the database being used by this instance.
              attr_accessor :isaacDbDependency
              # Source Code Management URL that contains the source code for the software running here.
              attr_accessor :scmUrl
              # The version of ISAAC that the rest service is running on top of.
              attr_accessor :isaacVersion
              # Software Licenses
              attr_accessor :appLicenses
              # Database Licenses
              attr_accessor :dbLicenses
              # The source content that was built into the underlying database.
              attr_accessor :dbDependencies

              # the json hash for this RestSystemInfo
              def to_jaxb_json_hash
                _h = {}
                if !supportedAPIVersions.nil?
                  _ha = Array.new
                  supportedAPIVersions.each { |_item| _ha.push _item.to_jaxb_json_hash }
                  _h['supportedAPIVersions'] = _ha
                end
                _h['apiImplementationVersion'] = apiImplementationVersion.to_jaxb_json_hash unless apiImplementationVersion.nil?
                _h['isaacDbDependency'] = isaacDbDependency.to_jaxb_json_hash unless isaacDbDependency.nil?
                _h['scmUrl'] = scmUrl.to_jaxb_json_hash unless scmUrl.nil?
                _h['isaacVersion'] = isaacVersion.to_jaxb_json_hash unless isaacVersion.nil?
                if !appLicenses.nil?
                  _ha = Array.new
                  appLicenses.each { |_item| _ha.push _item.to_jaxb_json_hash }
                  _h['appLicenses'] = _ha
                end
                if !dbLicenses.nil?
                  _ha = Array.new
                  dbLicenses.each { |_item| _ha.push _item.to_jaxb_json_hash }
                  _h['dbLicenses'] = _ha
                end
                if !dbDependencies.nil?
                  _ha = Array.new
                  dbDependencies.each { |_item| _ha.push _item.to_jaxb_json_hash }
                  _h['dbDependencies'] = _ha
                end
                return _h
              end

              # the json (string form) for this RestSystemInfo
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this RestSystemInfo with a json hash
              def init_jaxb_json_hash(_o)
                if !_o['supportedAPIVersions'].nil?
                  @supportedAPIVersions = Array.new
                  _oa = _o['supportedAPIVersions']
                  _oa.each { |_item|
                    if ((_item.nil? || _item['@class'].nil?) rescue true) 
                      @supportedAPIVersions.push String.from_json(_item)
                    else
                      clazz_array_parts = _item['@class'].split('.')
                      short_clazz = clazz_array_parts.pop
                      clazz_package = clazz_array_parts.map do |e|
                        e[0] = e.first.capitalize; e
                      end.join("::")
                      clazz = clazz_package + "::" + short_clazz
                      @supportedAPIVersions.push Object.const_get(clazz).send(:from_json, _item)
                    end
                  }
                end
                @apiImplementationVersion = String.from_json(_o['apiImplementationVersion']) unless _o['apiImplementationVersion'].nil?
                @isaacDbDependency = Gov::Vha::Isaac::Rest::Api1::Data::Systeminfo::RestDependencyInfo.from_json(_o['isaacDbDependency']) unless _o['isaacDbDependency'].nil?
                @scmUrl = String.from_json(_o['scmUrl']) unless _o['scmUrl'].nil?
                @isaacVersion = String.from_json(_o['isaacVersion']) unless _o['isaacVersion'].nil?
                if !_o['appLicenses'].nil?
                  @appLicenses = Array.new
                  _oa = _o['appLicenses']
                  _oa.each { |_item|
                    if ((_item.nil? || _item['@class'].nil?) rescue true) 
                      @appLicenses.push Gov::Vha::Isaac::Rest::Api1::Data::Systeminfo::RestLicenseInfo.from_json(_item)
                    else
                      clazz_array_parts = _item['@class'].split('.')
                      short_clazz = clazz_array_parts.pop
                      clazz_package = clazz_array_parts.map do |e|
                        e[0] = e.first.capitalize; e
                      end.join("::")
                      clazz = clazz_package + "::" + short_clazz
                      @appLicenses.push Object.const_get(clazz).send(:from_json, _item)
                    end
                  }
                end
                if !_o['dbLicenses'].nil?
                  @dbLicenses = Array.new
                  _oa = _o['dbLicenses']
                  _oa.each { |_item|
                    if ((_item.nil? || _item['@class'].nil?) rescue true) 
                      @dbLicenses.push Gov::Vha::Isaac::Rest::Api1::Data::Systeminfo::RestLicenseInfo.from_json(_item)
                    else
                      clazz_array_parts = _item['@class'].split('.')
                      short_clazz = clazz_array_parts.pop
                      clazz_package = clazz_array_parts.map do |e|
                        e[0] = e.first.capitalize; e
                      end.join("::")
                      clazz = clazz_package + "::" + short_clazz
                      @dbLicenses.push Object.const_get(clazz).send(:from_json, _item)
                    end
                  }
                end
                if !_o['dbDependencies'].nil?
                  @dbDependencies = Array.new
                  _oa = _o['dbDependencies']
                  _oa.each { |_item|
                    if ((_item.nil? || _item['@class'].nil?) rescue true) 
                      @dbDependencies.push Gov::Vha::Isaac::Rest::Api1::Data::Systeminfo::RestDependencyInfo.from_json(_item)
                    else
                      clazz_array_parts = _item['@class'].split('.')
                      short_clazz = clazz_array_parts.pop
                      clazz_package = clazz_array_parts.map do |e|
                        e[0] = e.first.capitalize; e
                      end.join("::")
                      clazz = clazz_package + "::" + short_clazz
                      @dbDependencies.push Object.const_get(clazz).send(:from_json, _item)
                    end
                  }
                end
              end

              # constructs a RestSystemInfo from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestLogicNode

                # The RestNodeSemanticType type of this node corresponding to the NodeSemantic enum
                attr_accessor :nodeSemantic
                # The UUID of the logic node itself (not of any referenced or associated component or concept)
                attr_accessor :nodeUuid
                # The list of child RestLogicNode instances contained within this RestLogicNode.
                # A RestTypedConnctorNode may have exactly one child node
                # A literal node may not have any child nodes at all
                # Others may have one or more child nodes
                attr_accessor :children

                # the json hash for this RestLogicNode
                def to_jaxb_json_hash
                  _h = {}
                  _h['nodeSemantic'] = nodeSemantic.to_jaxb_json_hash unless nodeSemantic.nil?
                  _h['nodeUuid'] = nodeUuid.to_jaxb_json_hash unless nodeUuid.nil?
                  if !children.nil?
                    _ha = Array.new
                    children.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['children'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestLogicNode
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestLogicNode with a json hash
                def init_jaxb_json_hash(_o)
                  @nodeSemantic = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestNodeSemanticType.from_json(_o['nodeSemantic']) unless _o['nodeSemantic'].nil?
                  @nodeUuid = String.from_json(_o['nodeUuid']) unless _o['nodeUuid'].nil?
                  if !_o['children'].nil?
                    @children = Array.new
                    _oa = _o['children']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @children.push Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @children.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestLogicNode from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestSememeVersions

                # Link to retrieve current page
                attr_accessor :paginationData
                # The contained results
                attr_accessor :results

                # the json hash for this RestSememeVersions
                def to_jaxb_json_hash
                  _h = {}
                  _h['paginationData'] = paginationData.to_jaxb_json_hash unless paginationData.nil?
                  if !results.nil?
                    _ha = Array.new
                    results.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['results'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestSememeVersions
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestSememeVersions with a json hash
                def init_jaxb_json_hash(_o)
                  @paginationData = Gov::Vha::Isaac::Rest::Api::Data::Pagination.from_json(_o['paginationData']) unless _o['paginationData'].nil?
                  if !_o['results'].nil?
                    @results = Array.new
                    _oa = _o['results']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @results.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestSememeVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @results.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSememeVersions from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api

          module Data

            # (no documentation provided)
            class Expandables

              # The list of data types that were not expanded on this request that could be expanded directly, or can
              # be expanded with a second trip by calling the provided URL
              attr_accessor :items

              # the json hash for this Expandables
              def to_jaxb_json_hash
                _h = {}
                if !items.nil?
                  _ha = Array.new
                  items.each { |_item| _ha.push _item.to_jaxb_json_hash }
                  _h['items'] = _ha
                end
                return _h
              end

              # the json (string form) for this Expandables
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this Expandables with a json hash
              def init_jaxb_json_hash(_o)
                if !_o['items'].nil?
                  @items = Array.new
                  _oa = _o['items']
                  _oa.each { |_item|
                    if ((_item.nil? || _item['@class'].nil?) rescue true) 
                      @items.push Gov::Vha::Isaac::Rest::Api::Data::Expandable.from_json(_item)
                    else
                      clazz_array_parts = _item['@class'].split('.')
                      short_clazz = clazz_array_parts.pop
                      clazz_package = clazz_array_parts.map do |e|
                        e[0] = e.first.capitalize; e
                      end.join("::")
                      clazz = clazz_package + "::" + short_clazz
                      @items.push Object.const_get(clazz).send(:from_json, _item)
                    end
                  }
                end
              end

              # constructs a Expandables from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Coordinate

              # (no documentation provided)
              class RestCoordinates

                # taxonomyCoordinate
                attr_accessor :taxonomyCoordinate
                # stampCoordinate
                attr_accessor :stampCoordinate
                # languageCoordinate
                attr_accessor :languageCoordinate
                # logicCoordinate
                attr_accessor :logicCoordinate

                # the json hash for this RestCoordinates
                def to_jaxb_json_hash
                  _h = {}
                  _h['taxonomyCoordinate'] = taxonomyCoordinate.to_jaxb_json_hash unless taxonomyCoordinate.nil?
                  _h['stampCoordinate'] = stampCoordinate.to_jaxb_json_hash unless stampCoordinate.nil?
                  _h['languageCoordinate'] = languageCoordinate.to_jaxb_json_hash unless languageCoordinate.nil?
                  _h['logicCoordinate'] = logicCoordinate.to_jaxb_json_hash unless logicCoordinate.nil?
                  return _h
                end

                # the json (string form) for this RestCoordinates
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestCoordinates with a json hash
                def init_jaxb_json_hash(_o)
                  @taxonomyCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestTaxonomyCoordinate.from_json(_o['taxonomyCoordinate']) unless _o['taxonomyCoordinate'].nil?
                  @stampCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestStampCoordinate.from_json(_o['stampCoordinate']) unless _o['stampCoordinate'].nil?
                  @languageCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestLanguageCoordinate.from_json(_o['languageCoordinate']) unless _o['languageCoordinate'].nil?
                  @logicCoordinate = Gov::Vha::Isaac::Rest::Api1::Data::Coordinate::RestLogicCoordinate.from_json(_o['logicCoordinate']) unless _o['logicCoordinate'].nil?
                end

                # constructs a RestCoordinates from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            # (no documentation provided)
            class RestIdentifiedObject

              # The globally unique, fixed, stable set of identifiers for the object
              attr_accessor :uuids

              # the json hash for this RestIdentifiedObject
              def to_jaxb_json_hash
                _h = {}
                if !uuids.nil?
                  _ha = Array.new
                  uuids.each { |_item| _ha.push _item.to_jaxb_json_hash }
                  _h['uuids'] = _ha
                end
                return _h
              end

              # the json (string form) for this RestIdentifiedObject
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this RestIdentifiedObject with a json hash
              def init_jaxb_json_hash(_o)
                if !_o['uuids'].nil?
                  @uuids = Array.new
                  _oa = _o['uuids']
                  _oa.each { |_item|
                    if ((_item.nil? || _item['@class'].nil?) rescue true) 
                      @uuids.push String.from_json(_item)
                    else
                      clazz_array_parts = _item['@class'].split('.')
                      short_clazz = clazz_array_parts.pop
                      clazz_package = clazz_array_parts.map do |e|
                        e[0] = e.first.capitalize; e
                      end.join("::")
                      clazz = clazz_package + "::" + short_clazz
                      @uuids.push Object.const_get(clazz).send(:from_json, _item)
                    end
                  }
                end
              end

              # constructs a RestIdentifiedObject from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class Enumeration

                # The name of this enumeration type
                attr_accessor :name
                # The identifier of this enumeration.  This would be passed back to a call that requested an enum type.
                attr_accessor :enumId

                # the json hash for this Enumeration
                def to_jaxb_json_hash
                  _h = {}
                  _h['name'] = name.to_jaxb_json_hash unless name.nil?
                  _h['enumId'] = enumId.to_jaxb_json_hash unless enumId.nil?
                  return _h
                end

                # the json (string form) for this Enumeration
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this Enumeration with a json hash
                def init_jaxb_json_hash(_o)
                  @name = String.from_json(_o['name']) unless _o['name'].nil?
                  @enumId = Fixnum.from_json(_o['enumId']) unless _o['enumId'].nil?
                end

                # constructs a Enumeration from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            # (no documentation provided)
            class RestStampedVersion

              # The stamp sequence of this version
              attr_accessor :stampSequence
              # The State of this version (active, inactive, primordial or cancelled)
              attr_accessor :state
              # The time stamp of this version (in standard java form)
              attr_accessor :time
              # The concept sequence of the concept that identifies the author of this version
              attr_accessor :authorSequence
              # The concept sequence of the module that this version is in
              attr_accessor :moduleSequence
              # The concept sequence of the path that this version is in
              attr_accessor :pathSequence

              # the json hash for this RestStampedVersion
              def to_jaxb_json_hash
                _h = {}
                _h['stampSequence'] = stampSequence.to_jaxb_json_hash unless stampSequence.nil?
                _h['state'] = state.to_jaxb_json_hash unless state.nil?
                _h['time'] = time.to_jaxb_json_hash unless time.nil?
                _h['authorSequence'] = authorSequence.to_jaxb_json_hash unless authorSequence.nil?
                _h['moduleSequence'] = moduleSequence.to_jaxb_json_hash unless moduleSequence.nil?
                _h['pathSequence'] = pathSequence.to_jaxb_json_hash unless pathSequence.nil?
                return _h
              end

              # the json (string form) for this RestStampedVersion
              def to_json
                to_jaxb_json_hash.to_json
              end

              #initializes this RestStampedVersion with a json hash
              def init_jaxb_json_hash(_o)
                @stampSequence = Fixnum.from_json(_o['stampSequence']) unless _o['stampSequence'].nil?
                @state = String.from_json(_o['state']) unless _o['state'].nil?
                @time = Bignum.from_json(_o['time']) unless _o['time'].nil?
                @authorSequence = Fixnum.from_json(_o['authorSequence']) unless _o['authorSequence'].nil?
                @moduleSequence = Fixnum.from_json(_o['moduleSequence']) unless _o['moduleSequence'].nil?
                @pathSequence = Fixnum.from_json(_o['pathSequence']) unless _o['pathSequence'].nil?
              end

              # constructs a RestStampedVersion from a (parsed) JSON hash
              def self.from_json(o)
                if o.nil?
                  return nil
                else
                  inst = new
                  inst.init_jaxb_json_hash o
                  return inst
                end
              end
            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Coordinate

              # (no documentation provided)
              class RestLanguageCoordinate

                # (no documentation provided)
                attr_accessor :language
                # (no documentation provided)
                attr_accessor :dialectAssemblagePreferences
                # (no documentation provided)
                attr_accessor :descriptionTypePreferences

                # the json hash for this RestLanguageCoordinate
                def to_jaxb_json_hash
                  _h = {}
                  _h['language'] = language.to_jaxb_json_hash unless language.nil?
                  if !dialectAssemblagePreferences.nil?
                    _ha = Array.new
                    dialectAssemblagePreferences.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['dialectAssemblagePreferences'] = _ha
                  end
                  if !descriptionTypePreferences.nil?
                    _ha = Array.new
                    descriptionTypePreferences.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['descriptionTypePreferences'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestLanguageCoordinate
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestLanguageCoordinate with a json hash
                def init_jaxb_json_hash(_o)
                  @language = Fixnum.from_json(_o['language']) unless _o['language'].nil?
                  if !_o['dialectAssemblagePreferences'].nil?
                    @dialectAssemblagePreferences = Array.new
                    _oa = _o['dialectAssemblagePreferences']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @dialectAssemblagePreferences.push Fixnum.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @dialectAssemblagePreferences.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                  if !_o['descriptionTypePreferences'].nil?
                    @descriptionTypePreferences = Array.new
                    _oa = _o['descriptionTypePreferences']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @descriptionTypePreferences.push Fixnum.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @descriptionTypePreferences.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestLanguageCoordinate from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestSememeChronology

                # The data that was not expanded as part of this call (but can be)
                attr_accessor :expandables
                # The sememe sequence identifier of this sememe instance
                attr_accessor :sememeSequence
                # The concept sequence identifier of the concept that represents the type of this sememe
                attr_accessor :assemblageSequence
                # The NID identifier of the object that is referenced by this sememe instance.  This could represent a concept or a sememe.
                attr_accessor :referencedComponentNid
                # The type of the object that is referenced by the referencedComponentNid value.  This would tell you if the nid represents a concept or a sememe.
                # Only populated when the expand parameter &#39;referencedDetails&#39; is passed.
                attr_accessor :referencedComponentNidObjectType
                # If the referencedComponentNid represents a concept, then this carries the &quot;best&quot; description for that concept.  This is selected based on the
                # attributes within the session for  stamp and language coordinates - or - if none present - the server default.  This is not populated if the
                # referencedComponentNid is a sememe type.
                # Only populated when the expand parameter &#39;referencedDetails&#39; is passed.
                attr_accessor :referencedComponentNidDescription
                # The permanent identifier object(s) attached to this sememe instance
                attr_accessor :identifiers
                # The list of sememe versions.  Depending on the expand parameter, may be empty, the latest only, or all versions.
                attr_accessor :versions

                # the json hash for this RestSememeChronology
                def to_jaxb_json_hash
                  _h = {}
                  _h['expandables'] = expandables.to_jaxb_json_hash unless expandables.nil?
                  _h['sememeSequence'] = sememeSequence.to_jaxb_json_hash unless sememeSequence.nil?
                  _h['assemblageSequence'] = assemblageSequence.to_jaxb_json_hash unless assemblageSequence.nil?
                  _h['referencedComponentNid'] = referencedComponentNid.to_jaxb_json_hash unless referencedComponentNid.nil?
                  _h['referencedComponentNidObjectType'] = referencedComponentNidObjectType.to_jaxb_json_hash unless referencedComponentNidObjectType.nil?
                  _h['referencedComponentNidDescription'] = referencedComponentNidDescription.to_jaxb_json_hash unless referencedComponentNidDescription.nil?
                  _h['identifiers'] = identifiers.to_jaxb_json_hash unless identifiers.nil?
                  if !versions.nil?
                    _ha = Array.new
                    versions.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['versions'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestSememeChronology
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestSememeChronology with a json hash
                def init_jaxb_json_hash(_o)
                  @expandables = Gov::Vha::Isaac::Rest::Api::Data::Expandables.from_json(_o['expandables']) unless _o['expandables'].nil?
                  @sememeSequence = Fixnum.from_json(_o['sememeSequence']) unless _o['sememeSequence'].nil?
                  @assemblageSequence = Fixnum.from_json(_o['assemblageSequence']) unless _o['assemblageSequence'].nil?
                  @referencedComponentNid = Fixnum.from_json(_o['referencedComponentNid']) unless _o['referencedComponentNid'].nil?
                  @referencedComponentNidObjectType = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestObjectChronologyType.from_json(_o['referencedComponentNidObjectType']) unless _o['referencedComponentNidObjectType'].nil?
                  @referencedComponentNidDescription = String.from_json(_o['referencedComponentNidDescription']) unless _o['referencedComponentNidDescription'].nil?
                  @identifiers = Gov::Vha::Isaac::Rest::Api1::Data::RestIdentifiedObject.from_json(_o['identifiers']) unless _o['identifiers'].nil?
                  if !_o['versions'].nil?
                    @versions = Array.new
                    _oa = _o['versions']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @versions.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestSememeVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @versions.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSememeChronology from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Search

              # (no documentation provided)
              class RestSearchResults

                # Link to retrieve current page
                attr_accessor :paginationData
                # The contained results
                attr_accessor :results

                # the json hash for this RestSearchResults
                def to_jaxb_json_hash
                  _h = {}
                  _h['paginationData'] = paginationData.to_jaxb_json_hash unless paginationData.nil?
                  if !results.nil?
                    _ha = Array.new
                    results.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['results'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestSearchResults
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestSearchResults with a json hash
                def init_jaxb_json_hash(_o)
                  @paginationData = Gov::Vha::Isaac::Rest::Api::Data::Pagination.from_json(_o['paginationData']) unless _o['paginationData'].nil?
                  if !_o['results'].nil?
                    @results = Array.new
                    _oa = _o['results']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @results.push Gov::Vha::Isaac::Rest::Api1::Data::Search::RestSearchResult.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @results.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSearchResults from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestDynamicSememeDefinition

                # The concept sequence of the concept that is used as an assemblage.  The rest of the descriptive details of the
                # sememe assemblage (returned in this object) are read from this concept.
                attr_accessor :assemblageConceptId
                # the user-friendly description of the overall purpose of this sememe
                attr_accessor :sememeUsageDescription
                # the column information that describes the data that may be returned as part of a sememe instance.
                attr_accessor :columnInfo
                # Return the RestObjectChronologyType of the restriction on referenced components for this sememe (if any - may return null)
                #
                # If there is a restriction, the nid set for the referenced component in an instance of this sememe must be of the type listed here.
                #
                # See rest/1/enumeration/restObjectChronologyType for a list of potential object types returned.
                attr_accessor :referencedComponentTypeRestriction
                # Return the RestSememeType of the sub restriction on referenced components for this DynamicSememe (if any - may return null)
                #
                # If there is a restriction, the nid set for the referenced component in an instance of this sememe must be of the type listed here.
                #
                # This is only applicable when #referencedComponentTypeRestriction returns RestObjectChronologyType#SEMEME
                #
                # See rest/1/enumeration/restSememeType for a list of potential object types returned.
                attr_accessor :referencedComponentTypeSubRestriction

                # the json hash for this RestDynamicSememeDefinition
                def to_jaxb_json_hash
                  _h = {}
                  _h['assemblageConceptId'] = assemblageConceptId.to_jaxb_json_hash unless assemblageConceptId.nil?
                  _h['sememeUsageDescription'] = sememeUsageDescription.to_jaxb_json_hash unless sememeUsageDescription.nil?
                  if !columnInfo.nil?
                    _ha = Array.new
                    columnInfo.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['columnInfo'] = _ha
                  end
                  _h['referencedComponentTypeRestriction'] = referencedComponentTypeRestriction.to_jaxb_json_hash unless referencedComponentTypeRestriction.nil?
                  _h['referencedComponentTypeSubRestriction'] = referencedComponentTypeSubRestriction.to_jaxb_json_hash unless referencedComponentTypeSubRestriction.nil?
                  return _h
                end

                # the json (string form) for this RestDynamicSememeDefinition
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestDynamicSememeDefinition with a json hash
                def init_jaxb_json_hash(_o)
                  @assemblageConceptId = Fixnum.from_json(_o['assemblageConceptId']) unless _o['assemblageConceptId'].nil?
                  @sememeUsageDescription = String.from_json(_o['sememeUsageDescription']) unless _o['sememeUsageDescription'].nil?
                  if !_o['columnInfo'].nil?
                    @columnInfo = Array.new
                    _oa = _o['columnInfo']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @columnInfo.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeColumnInfo.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @columnInfo.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                  @referencedComponentTypeRestriction = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestObjectChronologyType.from_json(_o['referencedComponentTypeRestriction']) unless _o['referencedComponentTypeRestriction'].nil?
                  @referencedComponentTypeSubRestriction = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestSememeType.from_json(_o['referencedComponentTypeSubRestriction']) unless _o['referencedComponentTypeSubRestriction'].nil?
                end

                # constructs a RestDynamicSememeDefinition from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Coordinate

              # (no documentation provided)
              class RestStampCoordinate

                # (no documentation provided)
                attr_accessor :time
                # (no documentation provided)
                attr_accessor :path
                # (no documentation provided)
                attr_accessor :precedence
                # (no documentation provided)
                attr_accessor :modules
                # (no documentation provided)
                attr_accessor :allowedStates

                # the json hash for this RestStampCoordinate
                def to_jaxb_json_hash
                  _h = {}
                  _h['time'] = time.to_jaxb_json_hash unless time.nil?
                  _h['path'] = path.to_jaxb_json_hash unless path.nil?
                  _h['precedence'] = precedence.to_jaxb_json_hash unless precedence.nil?
                  if !modules.nil?
                    _ha = Array.new
                    modules.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['modules'] = _ha
                  end
                  if !allowedStates.nil?
                    _ha = Array.new
                    allowedStates.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['allowedStates'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestStampCoordinate
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestStampCoordinate with a json hash
                def init_jaxb_json_hash(_o)
                  @time = Bignum.from_json(_o['time']) unless _o['time'].nil?
                  @path = Fixnum.from_json(_o['path']) unless _o['path'].nil?
                  @precedence = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestStampPrecedenceType.from_json(_o['precedence']) unless _o['precedence'].nil?
                  if !_o['modules'].nil?
                    @modules = Array.new
                    _oa = _o['modules']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @modules.push Fixnum.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @modules.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                  if !_o['allowedStates'].nil?
                    @allowedStates = Array.new
                    _oa = _o['allowedStates']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @allowedStates.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestStateType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @allowedStates.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestStampCoordinate from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestDynamicSememeData

                # The 0 indexed column number for this data.  Will not be populated for nested RestDynamicSememeData objects where the &#39;data&#39; field
                # is of type RestDynamicSememeArray
                attr_accessor :columnNumber
                # The data for a column within a RestDynamicSememeVersion instance
                attr_accessor :data

                # the json hash for this RestDynamicSememeData
                def to_jaxb_json_hash
                  _h = {}
                  _h['columnNumber'] = columnNumber.to_jaxb_json_hash unless columnNumber.nil?
                  _h['data'] = data.to_jaxb_json_hash unless data.nil?
                  return _h
                end

                # the json (string form) for this RestDynamicSememeData
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestDynamicSememeData with a json hash
                def init_jaxb_json_hash(_o)
                  @columnNumber = Fixnum.from_json(_o['columnNumber']) unless _o['columnNumber'].nil?
                  @data = Object.from_json(_o['data']) unless _o['data'].nil?
                end

                # constructs a RestDynamicSememeData from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Systeminfo

              # (no documentation provided)
              class RestDependencyInfo

                # Maven Dependency Group ID
                attr_accessor :groupId
                # Maven Dependency Artifact ID
                attr_accessor :artifactId
                # Maven Dependency Version
                attr_accessor :version
                # Maven Dependency Classifier
                attr_accessor :classifier
                # Maven Dependency Type
                attr_accessor :type

                # the json hash for this RestDependencyInfo
                def to_jaxb_json_hash
                  _h = {}
                  _h['groupId'] = groupId.to_jaxb_json_hash unless groupId.nil?
                  _h['artifactId'] = artifactId.to_jaxb_json_hash unless artifactId.nil?
                  _h['version'] = version.to_jaxb_json_hash unless version.nil?
                  _h['classifier'] = classifier.to_jaxb_json_hash unless classifier.nil?
                  _h['type'] = type.to_jaxb_json_hash unless type.nil?
                  return _h
                end

                # the json (string form) for this RestDependencyInfo
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestDependencyInfo with a json hash
                def init_jaxb_json_hash(_o)
                  @groupId = String.from_json(_o['groupId']) unless _o['groupId'].nil?
                  @artifactId = String.from_json(_o['artifactId']) unless _o['artifactId'].nil?
                  @version = String.from_json(_o['version']) unless _o['version'].nil?
                  @classifier = String.from_json(_o['classifier']) unless _o['classifier'].nil?
                  @type = String.from_json(_o['type']) unless _o['type'].nil?
                end

                # constructs a RestDependencyInfo from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Systeminfo

              # (no documentation provided)
              class RestLicenseInfo

                # Name of the license
                attr_accessor :name
                # URL to the license text
                attr_accessor :url
                # Comments related to the license
                attr_accessor :comments

                # the json hash for this RestLicenseInfo
                def to_jaxb_json_hash
                  _h = {}
                  _h['name'] = name.to_jaxb_json_hash unless name.nil?
                  _h['url'] = url.to_jaxb_json_hash unless url.nil?
                  _h['comments'] = comments.to_jaxb_json_hash unless comments.nil?
                  return _h
                end

                # the json (string form) for this RestLicenseInfo
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestLicenseInfo with a json hash
                def init_jaxb_json_hash(_o)
                  @name = String.from_json(_o['name']) unless _o['name'].nil?
                  @url = String.from_json(_o['url']) unless _o['url'].nil?
                  @comments = String.from_json(_o['comments']) unless _o['comments'].nil?
                end

                # constructs a RestLicenseInfo from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestDynamicSememeColumnInfo

                # The concept sequence number of the concept that represents the column within the dynamic sememe.
                attr_accessor :columnConceptSequence
                # The user-friendly name to display for this column.
                attr_accessor :columnName
                # The user friendly description for this column.  Suitable for things like tooltip descriptions.
                attr_accessor :columnDescription
                # The 0 indexed order of this column within the dynamic sememe.
                attr_accessor :columnOrder
                # The type of data that will be found in this column.  String, Integer, etc.  See
                # rest/1/enumeration/restDynamicSememeDataType for a list of all of the possible data types.
                attr_accessor :columnDataType
                # The default value to use for this column when creating a new sememe (if no user value is specified).
                # This field is optional and may be null.
                attr_accessor :columnDefaultData
                # Does the user have to provide a value for this column in order to create an instance of this sememe.
                attr_accessor :columnRequired
                # The validators types that are attached to this sememe (if any).  Interval, &lt;, etc.  See
                # rest/1/enumeration/restDynamicSememeValidatorType for a list of all possible validator types.
                attr_accessor :columnValidatorTypes
                # The data required to execute the validator type specified in columnValidatorTypes.  The format and type of this field
                # will depend on the columnValidatorTypes field.  The positions within this array will match with the columnValidatorTypes
                # array.
                attr_accessor :columnValidatorData

                # the json hash for this RestDynamicSememeColumnInfo
                def to_jaxb_json_hash
                  _h = {}
                  _h['columnConceptSequence'] = columnConceptSequence.to_jaxb_json_hash unless columnConceptSequence.nil?
                  _h['columnName'] = columnName.to_jaxb_json_hash unless columnName.nil?
                  _h['columnDescription'] = columnDescription.to_jaxb_json_hash unless columnDescription.nil?
                  _h['columnOrder'] = columnOrder.to_jaxb_json_hash unless columnOrder.nil?
                  _h['columnDataType'] = columnDataType.to_jaxb_json_hash unless columnDataType.nil?
                  _h['columnDefaultData'] = columnDefaultData.to_jaxb_json_hash unless columnDefaultData.nil?
                  _h['columnRequired'] = columnRequired.to_jaxb_json_hash unless columnRequired.nil?
                  if !columnValidatorTypes.nil?
                    _ha = Array.new
                    columnValidatorTypes.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['columnValidatorTypes'] = _ha
                  end
                  if !columnValidatorData.nil?
                    _ha = Array.new
                    columnValidatorData.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['columnValidatorData'] = _ha
                  end
                  return _h
                end

                # the json (string form) for this RestDynamicSememeColumnInfo
                def to_json
                  to_jaxb_json_hash.to_json
                end

                #initializes this RestDynamicSememeColumnInfo with a json hash
                def init_jaxb_json_hash(_o)
                  @columnConceptSequence = Fixnum.from_json(_o['columnConceptSequence']) unless _o['columnConceptSequence'].nil?
                  @columnName = String.from_json(_o['columnName']) unless _o['columnName'].nil?
                  @columnDescription = String.from_json(_o['columnDescription']) unless _o['columnDescription'].nil?
                  @columnOrder = Fixnum.from_json(_o['columnOrder']) unless _o['columnOrder'].nil?
                  @columnDataType = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestDynamicSememeDataType.from_json(_o['columnDataType']) unless _o['columnDataType'].nil?
                  @columnDefaultData = Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData.from_json(_o['columnDefaultData']) unless _o['columnDefaultData'].nil?
                  @columnRequired = Boolean.from_json(_o['columnRequired']) unless _o['columnRequired'].nil?
                  if !_o['columnValidatorTypes'].nil?
                    @columnValidatorTypes = Array.new
                    _oa = _o['columnValidatorTypes']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @columnValidatorTypes.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestDynamicSememeValidatorType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @columnValidatorTypes.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                  if !_o['columnValidatorData'].nil?
                    @columnValidatorData = Array.new
                    _oa = _o['columnValidatorData']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @columnValidatorData.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @columnValidatorData.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestDynamicSememeColumnInfo from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestLiteralNodeBoolean < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # RestLiteralNodeBoolean contains a literal boolean value, literalValue
                attr_accessor :literalValue

                # the json hash for this RestLiteralNodeBoolean
                def to_jaxb_json_hash
                  _h = super
                  _h['literalValue'] = literalValue.to_jaxb_json_hash unless literalValue.nil?
                  return _h
                end

                #initializes this RestLiteralNodeBoolean with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @literalValue = Boolean.from_json(_o['literalValue']) unless _o['literalValue'].nil?
                end

                # constructs a RestLiteralNodeBoolean from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Ochre

        module Api

          # (no documentation provided)
          class State

            #
            INACTIVE = "INACTIVE"

            #
            ACTIVE = "ACTIVE"

            #
            PRIMORDIAL = "PRIMORDIAL"

            #
            CANCELED = "CANCELED"
          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeDouble < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeDouble
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeDouble with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeDouble from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestLiteralNodeInstant < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # RestLiteralNodeInstant contains a literal Instant value, literalValue
                attr_accessor :literalValue

                # the json hash for this RestLiteralNodeInstant
                def to_jaxb_json_hash
                  _h = super
                  _h['literalValue'] = literalValue.to_jaxb_json_hash unless literalValue.nil?
                  return _h
                end

                #initializes this RestLiteralNodeInstant with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @literalValue = java.time::Instant.from_json(_o['literalValue']) unless _o['literalValue'].nil?
                end

                # constructs a RestLiteralNodeInstant from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestConceptNode < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # The int sequence of the concept referred to by this REST logic graph node
                attr_accessor :conceptSequence
                # Optionally-expandable RestConceptVersion corresponding to
                attr_accessor :conceptVersion
                # A boolean indicating whether the concept referred to by this RestConceptVersion is defined rather than primitive
                attr_accessor :isConceptDefined
                # The String text description of the concept referred to by this REST logic graph node. It is included as a convenience, as it may be retrieved based on the concept sequence.
                attr_accessor :conceptDescription

                # the json hash for this RestConceptNode
                def to_jaxb_json_hash
                  _h = super
                  _h['conceptSequence'] = conceptSequence.to_jaxb_json_hash unless conceptSequence.nil?
                  _h['conceptVersion'] = conceptVersion.to_jaxb_json_hash unless conceptVersion.nil?
                  _h['isConceptDefined'] = isConceptDefined.to_jaxb_json_hash unless isConceptDefined.nil?
                  _h['conceptDescription'] = conceptDescription.to_jaxb_json_hash unless conceptDescription.nil?
                  return _h
                end

                #initializes this RestConceptNode with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @conceptSequence = Fixnum.from_json(_o['conceptSequence']) unless _o['conceptSequence'].nil?
                  @conceptVersion = Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptVersion.from_json(_o['conceptVersion']) unless _o['conceptVersion'].nil?
                  @isConceptDefined = Boolean.from_json(_o['isConceptDefined']) unless _o['isConceptDefined'].nil?
                  @conceptDescription = String.from_json(_o['conceptDescription']) unless _o['conceptDescription'].nil?
                end

                # constructs a RestConceptNode from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestDynamicSememeTypedData < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData

                # The type of the object that is referenced by the data.  This would tell you if the (nid, sequence or UUID) represents a concept or a sememe (or unknown).
                # Especially in the case of a RestDynamicSememeSequence, the value may come back as unknown - the caller will have to refer to the documentation of the sememe
                # to determine the actual type of the data stored here in those cases.
                attr_accessor :dataObjectType
                # If the dataObjectType represents is a concept, then this carries the &quot;best&quot; description for that concept.  This is selected based on the
                # attributes within the session for  stamp and language coordinates - or - if none present - the server default.  This is not populated if the
                # dataObjectType is not a concept type.
                # Only populated when the expand parameter &#39;referencedDetails&#39; is passed.
                attr_accessor :conceptDescription

                # the json hash for this RestDynamicSememeTypedData
                def to_jaxb_json_hash
                  _h = super
                  _h['dataObjectType'] = dataObjectType.to_jaxb_json_hash unless dataObjectType.nil?
                  _h['conceptDescription'] = conceptDescription.to_jaxb_json_hash unless conceptDescription.nil?
                  return _h
                end

                #initializes this RestDynamicSememeTypedData with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @dataObjectType = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestObjectChronologyType.from_json(_o['dataObjectType']) unless _o['dataObjectType'].nil?
                  @conceptDescription = String.from_json(_o['conceptDescription']) unless _o['conceptDescription'].nil?
                end

                # constructs a RestDynamicSememeTypedData from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestNodeSemanticType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestNodeSemanticType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestNodeSemanticType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestNodeSemanticType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestNodeSemanticType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeArray < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeArray
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeArray with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeArray from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestConcreteDomainOperatorsType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestConcreteDomainOperatorsType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestConcreteDomainOperatorsType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestConcreteDomainOperatorsType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestConcreteDomainOperatorsType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestObjectChronologyType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestObjectChronologyType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestObjectChronologyType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestObjectChronologyType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestObjectChronologyType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestLiteralNodeInteger < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # RestLiteralNodeInteger contains a literal int value, literalValue
                attr_accessor :literalValue

                # the json hash for this RestLiteralNodeInteger
                def to_jaxb_json_hash
                  _h = super
                  _h['literalValue'] = literalValue.to_jaxb_json_hash unless literalValue.nil?
                  return _h
                end

                #initializes this RestLiteralNodeInteger with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @literalValue = Fixnum.from_json(_o['literalValue']) unless _o['literalValue'].nil?
                end

                # constructs a RestLiteralNodeInteger from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestStateType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestStateType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestStateType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestStateType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestStateType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestSupportedIdType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestSupportedIdType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestSupportedIdType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestSupportedIdType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSupportedIdType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestLiteralNodeString < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # RestLiteralNodeString contains a literal String value, literalValue
                attr_accessor :literalValue

                # the json hash for this RestLiteralNodeString
                def to_jaxb_json_hash
                  _h = super
                  _h['literalValue'] = literalValue.to_jaxb_json_hash unless literalValue.nil?
                  return _h
                end

                #initializes this RestLiteralNodeString with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @literalValue = String.from_json(_o['literalValue']) unless _o['literalValue'].nil?
                end

                # constructs a RestLiteralNodeString from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestUntypedConnectorNode < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode


                # the json hash for this RestUntypedConnectorNode
                def to_jaxb_json_hash
                  _h = super
                  return _h
                end

                #initializes this RestUntypedConnectorNode with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                end

                # constructs a RestUntypedConnectorNode from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestSememeDescriptionVersion < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestSememeVersion

                # The concept sequence of the concept that represents the case significance flag on the description .
                # This should be description case sensitive, description not case sensitive or description initial character sensitive
                attr_accessor :caseSignificanceConceptSequence
                # The concept sequence of the concept that represents the language of the description (note, this is NOT
                # the dialect)
                attr_accessor :languageConceptSequence
                # The text of the description
                attr_accessor :text
                # The concept sequence of the concept that represents the type of the description.
                # This should be FSN, Synonym, or Definition.
                attr_accessor :descriptionTypeConceptSequence
                # The dialects attached to this sememe.  Not populated by default, include expand=nestedSememes to expand this.
                attr_accessor :dialects

                # the json hash for this RestSememeDescriptionVersion
                def to_jaxb_json_hash
                  _h = super
                  _h['caseSignificanceConceptSequence'] = caseSignificanceConceptSequence.to_jaxb_json_hash unless caseSignificanceConceptSequence.nil?
                  _h['languageConceptSequence'] = languageConceptSequence.to_jaxb_json_hash unless languageConceptSequence.nil?
                  _h['text'] = text.to_jaxb_json_hash unless text.nil?
                  _h['descriptionTypeConceptSequence'] = descriptionTypeConceptSequence.to_jaxb_json_hash unless descriptionTypeConceptSequence.nil?
                  if !dialects.nil?
                    _ha = Array.new
                    dialects.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['dialects'] = _ha
                  end
                  return _h
                end

                #initializes this RestSememeDescriptionVersion with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @caseSignificanceConceptSequence = Fixnum.from_json(_o['caseSignificanceConceptSequence']) unless _o['caseSignificanceConceptSequence'].nil?
                  @languageConceptSequence = Fixnum.from_json(_o['languageConceptSequence']) unless _o['languageConceptSequence'].nil?
                  @text = String.from_json(_o['text']) unless _o['text'].nil?
                  @descriptionTypeConceptSequence = Fixnum.from_json(_o['descriptionTypeConceptSequence']) unless _o['descriptionTypeConceptSequence'].nil?
                  if !_o['dialects'].nil?
                    @dialects = Array.new
                    _oa = _o['dialects']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @dialects.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeVersion.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @dialects.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSememeDescriptionVersion from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeByteArray < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeByteArray
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeByteArray with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeByteArray from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestDynamicSememeVersion < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestSememeVersion

                # The data attached to this sememe instance (if any).  The &#39;sememe/sememeDefinition/{id}&#39;
                # can be read to determine the potential types and descriptions of these columns.
                attr_accessor :dataColumns

                # the json hash for this RestDynamicSememeVersion
                def to_jaxb_json_hash
                  _h = super
                  if !dataColumns.nil?
                    _ha = Array.new
                    dataColumns.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['dataColumns'] = _ha
                  end
                  return _h
                end

                #initializes this RestDynamicSememeVersion with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['dataColumns'].nil?
                    @dataColumns = Array.new
                    _oa = _o['dataColumns']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @dataColumns.push Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @dataColumns.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestDynamicSememeVersion from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestTypedConnectorNode < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # RestTypedConnectorNode contains an int connectorTypeConceptSequence identifying a connector type concept
                attr_accessor :connectorTypeConceptSequence
                # Optionally-populated connectorTypeConceptVersion
                attr_accessor :connectorTypeConceptVersion
                # RestTypedConnectorNode contains a String connectorTypeConceptDescription describing a connector type concept
                attr_accessor :connectorTypeConceptDescription

                # the json hash for this RestTypedConnectorNode
                def to_jaxb_json_hash
                  _h = super
                  _h['connectorTypeConceptSequence'] = connectorTypeConceptSequence.to_jaxb_json_hash unless connectorTypeConceptSequence.nil?
                  _h['connectorTypeConceptVersion'] = connectorTypeConceptVersion.to_jaxb_json_hash unless connectorTypeConceptVersion.nil?
                  _h['connectorTypeConceptDescription'] = connectorTypeConceptDescription.to_jaxb_json_hash unless connectorTypeConceptDescription.nil?
                  return _h
                end

                #initializes this RestTypedConnectorNode with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @connectorTypeConceptSequence = Fixnum.from_json(_o['connectorTypeConceptSequence']) unless _o['connectorTypeConceptSequence'].nil?
                  @connectorTypeConceptVersion = Gov::Vha::Isaac::Rest::Api1::Data::Concept::RestConceptVersion.from_json(_o['connectorTypeConceptVersion']) unless _o['connectorTypeConceptVersion'].nil?
                  @connectorTypeConceptDescription = String.from_json(_o['connectorTypeConceptDescription']) unless _o['connectorTypeConceptDescription'].nil?
                end

                # constructs a RestTypedConnectorNode from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              # (no documentation provided)
              class RestSememeLogicGraphVersion < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestSememeVersion

                # The String text of the description of the associated concept
                attr_accessor :referencedConceptDescription
                # A boolean indicating whether the concept referred to by this
                # RestSememeLogicGraphVersion is defined rather than primitive
                attr_accessor :isReferencedConceptDefined
                # The root node of the logical expression tree associated with the concept
                attr_accessor :rootLogicNode

                # the json hash for this RestSememeLogicGraphVersion
                def to_jaxb_json_hash
                  _h = super
                  _h['referencedConceptDescription'] = referencedConceptDescription.to_jaxb_json_hash unless referencedConceptDescription.nil?
                  _h['isReferencedConceptDefined'] = isReferencedConceptDefined.to_jaxb_json_hash unless isReferencedConceptDefined.nil?
                  _h['rootLogicNode'] = rootLogicNode.to_jaxb_json_hash unless rootLogicNode.nil?
                  return _h
                end

                #initializes this RestSememeLogicGraphVersion with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @referencedConceptDescription = String.from_json(_o['referencedConceptDescription']) unless _o['referencedConceptDescription'].nil?
                  @isReferencedConceptDefined = Boolean.from_json(_o['isReferencedConceptDefined']) unless _o['isReferencedConceptDefined'].nil?
                  @rootLogicNode = Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode.from_json(_o['rootLogicNode']) unless _o['rootLogicNode'].nil?
                end

                # constructs a RestSememeLogicGraphVersion from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestLiteralNodeFloat < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestLogicNode

                # RestLiteralNodeFloat contains a literal float value, literalValue
                attr_accessor :literalValue

                # the json hash for this RestLiteralNodeFloat
                def to_jaxb_json_hash
                  _h = super
                  _h['literalValue'] = literalValue.to_jaxb_json_hash unless literalValue.nil?
                  return _h
                end

                #initializes this RestLiteralNodeFloat with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @literalValue = Float.from_json(_o['literalValue']) unless _o['literalValue'].nil?
                end

                # constructs a RestLiteralNodeFloat from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestSememeType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestSememeType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestSememeType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestSememeType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestSememeType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeBoolean < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeBoolean
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeBoolean with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeBoolean from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeString < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeString
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeString with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeString from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeFloat < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeFloat
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeFloat with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeFloat from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestStampPrecedenceType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestStampPrecedenceType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestStampPrecedenceType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestStampPrecedenceType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestStampPrecedenceType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeLong < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeLong
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeLong with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeLong from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestDynamicSememeDataType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestDynamicSememeDataType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestDynamicSememeDataType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestDynamicSememeDataType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestDynamicSememeDataType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Enumerations

              # (no documentation provided)
              class RestDynamicSememeValidatorType < Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::Enumeration

                # (no documentation provided)
                attr_accessor :all

                # the json hash for this RestDynamicSememeValidatorType
                def to_jaxb_json_hash
                  _h = super
                  if !all.nil?
                    _ha = Array.new
                    all.each { |_item| _ha.push _item.to_jaxb_json_hash }
                    _h['all'] = _ha
                  end
                  return _h
                end

                #initializes this RestDynamicSememeValidatorType with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  if !_o['all'].nil?
                    @all = Array.new
                    _oa = _o['all']
                    _oa.each { |_item|
                      if ((_item.nil? || _item['@class'].nil?) rescue true) 
                        @all.push Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestDynamicSememeValidatorType.from_json(_item)
                      else
                        clazz_array_parts = _item['@class'].split('.')
                        short_clazz = clazz_array_parts.pop
                        clazz_package = clazz_array_parts.map do |e|
                          e[0] = e.first.capitalize; e
                        end.join("::")
                        clazz = clazz_package + "::" + short_clazz
                        @all.push Object.const_get(clazz).send(:from_json, _item)
                      end
                    }
                  end
                end

                # constructs a RestDynamicSememeValidatorType from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeInteger < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeData


                  # the json hash for this RestDynamicSememeInteger
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeInteger with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeInteger from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeNid < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeTypedData


                  # the json hash for this RestDynamicSememeNid
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeNid with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeNid from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeSequence < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeTypedData


                  # the json hash for this RestDynamicSememeSequence
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeSequence with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeSequence from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestFeatureNode < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestTypedConnectorNode

                # RestFeatureNode contains a RestConcreteDomainOperatorsType/ConcreteDomainOperators instance,
                # which is an enumeration specifying a type of comparison
                #
                # RestFeatureNode must have exactly 1 child node.
                #
                # Available RestConcreteDomainOperatorsType/ConcreteDomainOperator values include
                # EQUALS,
                # LESS_THAN,
                # LESS_THAN_EQUALS,
                # GREATER_THAN,
                # GREATER_THAN_EQUALS
                attr_accessor :operator

                # the json hash for this RestFeatureNode
                def to_jaxb_json_hash
                  _h = super
                  _h['operator'] = operator.to_jaxb_json_hash unless operator.nil?
                  return _h
                end

                #initializes this RestFeatureNode with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                  @operator = Gov::Vha::Isaac::Rest::Api1::Data::Enumerations::RestConcreteDomainOperatorsType.from_json(_o['operator']) unless _o['operator'].nil?
                end

                # constructs a RestFeatureNode from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Sememe

              module DataTypes

                # (no documentation provided)
                class RestDynamicSememeUUID < Gov::Vha::Isaac::Rest::Api1::Data::Sememe::RestDynamicSememeTypedData


                  # the json hash for this RestDynamicSememeUUID
                  def to_jaxb_json_hash
                    _h = super
                    return _h
                  end

                  #initializes this RestDynamicSememeUUID with a json hash
                  def init_jaxb_json_hash(_o)
                    super _o
                  end

                  # constructs a RestDynamicSememeUUID from a (parsed) JSON hash
                  def self.from_json(o)
                    if o.nil?
                      return nil
                    else
                      inst = new
                      inst.init_jaxb_json_hash o
                      return inst
                    end
                  end
                end

              end

            end

          end

        end

      end

    end

  end

end

module Gov

  module Vha

    module Isaac

      module Rest

        module Api1

          module Data

            module Logic

              # (no documentation provided)
              class RestRoleNode < Gov::Vha::Isaac::Rest::Api1::Data::Logic::RestTypedConnectorNode


                # the json hash for this RestRoleNode
                def to_jaxb_json_hash
                  _h = super
                  return _h
                end

                #initializes this RestRoleNode with a json hash
                def init_jaxb_json_hash(_o)
                  super _o
                end

                # constructs a RestRoleNode from a (parsed) JSON hash
                def self.from_json(o)
                  if o.nil?
                    return nil
                  else
                    inst = new
                    inst.init_jaxb_json_hash o
                    return inst
                  end
                end
              end

            end

          end

        end

      end

    end

  end

end