package gov.vha.isaac.rf2.convert.mojo;

import java.util.Collection;
import java.util.TreeSet;
import java.util.UUID;

/**
 * A group of relationships that all have the same ID (different states of the same rel across time)
 * {@link RelBatch}
 *
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a>
 */
public class RelBatch
{
	private TreeSet<Rel> rels_ = new TreeSet<>();
	
	protected RelBatch(Rel r)
	{
		rels_.add(r);
	}
	
	protected UUID getBatchId()
	{
		return rels_.first().id;
	}
	
	protected UUID getSourceId()
	{
		return rels_.first().sourceId;
	}
	
	protected boolean isActiveNow()
	{
		return rels_.last().isActive;
	}
	
	protected void addRel(Rel rel)
	{
		rels_.add(rel);
		if (!rels_.first().sourceId.equals(rel.sourceId))
		{
			throw new RuntimeException("oops!");
		}
	}
	
	/**
	 * ordered by effectiveTime
	 * @return
	 */
	protected TreeSet<Rel> getRels()
	{
		return rels_;
	}
}
