package gov.vha.isaac.rf2.convert.mojo;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.UUID;

import gov.va.oia.terminology.converters.sharedUtils.sql.TableDefinition;
import gov.vha.isaac.ochre.api.util.UuidT3Generator;

public class Rel implements Comparable<Rel>
{
	//private static Logger LOG = LogManager.getLogger();

	Long sctID;
	UUID id;
	long effectiveTime;
	boolean isActive;
	UUID moduleId;
	UUID sourceId;
	UUID destinationId;
	String relGroup;
	UUID typeId;
	UUID characteristicTypeId;
	UUID modifierId;
	
	public Rel(ResultSet rs, TableDefinition td) throws ParseException, SQLException
	{
		if (td.getColDataType("ID").isLong())
		{
			sctID = rs.getLong("ID");
			id = UuidT3Generator.fromSNOMED(sctID);
		}
		else
		{
			id = UUID.fromString(rs.getString("ID"));
		}
		effectiveTime  = RF2Mojo.dateParse.parse(rs.getString("EFFECTIVETIME")).getTime();
		isActive = rs.getBoolean("ACTIVE");
		moduleId = (td.getColDataType("MODULEID").isLong() ? UuidT3Generator.fromSNOMED(rs.getLong("MODULEID")) : 
			UUID.fromString(rs.getString("MODULEID")));
		sourceId = (td.getColDataType("SOURCEID").isLong() ? UuidT3Generator.fromSNOMED(rs.getLong("SOURCEID")) : 
			UUID.fromString(rs.getString("SOURCEID")));
		destinationId = (td.getColDataType("DESTINATIONID").isLong() ? UuidT3Generator.fromSNOMED(rs.getLong("DESTINATIONID")) : 
			UUID.fromString(rs.getString("DESTINATIONID")));
		relGroup = rs.getString("relationshipGroup");
		typeId = (td.getColDataType("typeId").isLong() ? UuidT3Generator.fromSNOMED(rs.getLong("typeId")) : 
			UUID.fromString(rs.getString("typeId")));
		characteristicTypeId = (td.getColDataType("characteristicTypeId").isLong() ? UuidT3Generator.fromSNOMED(rs.getLong("characteristicTypeId")) : 
			UUID.fromString(rs.getString("characteristicTypeId")));
		modifierId = (td.getColDataType("modifierId").isLong() ? UuidT3Generator.fromSNOMED(rs.getLong("modifierId")) : 
			UUID.fromString(rs.getString("modifierId")));
	}

	@Override
	public int compareTo(Rel o)
	{
		return Long.compare(effectiveTime, o.effectiveTime);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Rel [sctID=" + sctID + ", id=" + id + ", isActive=" + isActive + ", moduleId=" + moduleId
				+ ", sourceId=" + sourceId + ", destinationId=" + destinationId + ", relGroup=" + relGroup + ", typeId="
				+ typeId + ", characteristicTypeId=" + characteristicTypeId + "]";
	}
}
