package gov.vha.isaac.utils.file_transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

import org.junit.Assert;

import com.fasterxml.jackson.databind.ObjectMapper;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Unit test for simple App.
 */
public class FileTransferTest 
extends TestCase
{
	/**
	 * Create the test case
	 *
	 * @param testName name of the test case
	 */
	public FileTransferTest( String testName )
	{
		super( testName );
	}

	/**
	 * @return the suite of tests being tested
	 */
	public static Test suite()
	{
		return new TestSuite( FileTransferTest.class );
	}

	private static String convertStreamToString(java.io.InputStream is) {
		java.util.Scanner s = new java.util.Scanner(is).useDelimiter("\\A");
		return s.hasNext() ? s.next() : "";
	}

	private Config getEffectiveConfig(String resourceFileBaseName) {
		InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceFileBaseName);
		String jsonInString = convertStreamToString(in);

		ObjectMapper mapper = new ObjectMapper();

		Config objFromJSon = null;
		try {
			//JSON from file to Object
			//Config obj = mapper.readValue(new File("c:\\configfile.json"), Config.class);

			//JSON from String to Config Object
			objFromJSon = mapper.readValue(jsonInString, Config.class);
			System.out.println("Read file-transfer cfg json from file: " + objFromJSon);
		} catch (IOException e) {
			System.err.println("Failed serializing object. Caught " + e.getClass().getClass().getName() + " " + e.getLocalizedMessage());
			e.printStackTrace();
			Assert.fail("Failed serializing object. Caught " + e.getClass().getClass().getName() + " " + e.getLocalizedMessage());
		}

		Config effectiveConfigFromConfigFromJSon = Config.getEffectiveConfig(objFromJSon);

		System.out.println("Read effective file-transfer cfg json from file: " + effectiveConfigFromConfigFromJSon);	
	
		return effectiveConfigFromConfigFromJSon;
	}

	/**
	 * Rigourous Test :-)
	 * @throws Exception 
	 * @throws MalformedURLException 
	 */
	public void testAppSmall() throws MalformedURLException, Exception
	{
		//Config effectiveConfigFromConfigFromJSon = getEffectiveConfig("file-transfer-test-release-small.cfg");
		
		//FileTransfer.download(effectiveConfigFromConfigFromJSon, "http://vadev.mantech.com:8081/nexus/content/repositories/releases/", "devtest", "devtest");
	}
}
