#! /usr/bin/python
#
# Utility to remove a remote from all repositories
#
#
#
#

import subprocess


projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

remoteName = 'origin'

for project in projects:
	print("==================================")
	print("Removing Remote from " + project)
	git("-C", project, "remote", "remove", remoteName)
	git("-C", project, "remote", "-v")
	print("==================================")
	print("");