#! /usr/bin/python
#
# This script clones each project from GIT
#
#  Utilize something like this, ahead of time, to cache https credentials...
#  git config --global credential.helper cache
#  git config --global credential.https://vadev.mantech.com darmbrust
#
import subprocess
import os

projects = ['ISAAC-developer-docs',
			'ISAAC',
			'ISAAC-term-convert-rf2',
			'ISAAC-term-convert-vhat',
			'ISAAC-term-convert-loinc',
			'ISAAC-term-convert-rxnorm',
			'ISAAC-db-builder-solor',
			'ISAAC-db-builder-vhat',
			'ISAAC-db-builder-vets',
			'ISAAC-fx-gui',
			'ISAAC-fx-gui-pa',
			'ISAAC-rest',
			'ISAAC-file-transfer-utils',
			'rails_common',
			'rails_komet',
			'rails_prisme']

def git(*args):
	return subprocess.check_call(['git'] + list(args))

gitHubURL = 'https://vadev.mantech.com:4848/git/r/'
branch = 'develop'

for project in projects:
		if os.path.isdir(os.getcwd() + os.sep + project)== False:
				print(os.getcwd() + os.sep + project + " does not exist")
				thisProjectUrl = gitHubURL + project + '.git'
				print("==================================")
				print("Cloning Latest From " + project)
				
				tmpBranch = ''
				if project == 'ISAAC-developer-docs':
					tmpBranch = 'master'
				else:
					tmpBranch = branch
				
				git("clone", "--branch", tmpBranch, thisProjectUrl)
				print("==================================")
				print("");
		else:
				print(project + " already exists in " + os.getcwd())
