package gov.va.med.ars.transform;
import java.io.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;

public class Transform {
	public static void main(String[] args) throws TransformerException {
		String stylesheetPathname = args[0];
		String inputPathname = args[1];
		String outputPathname = args[2];

		TransformerFactory factory = TransformerFactory.newInstance();
		Source stylesheetSource = new StreamSource(new File(stylesheetPathname).getAbsoluteFile());
		
		Transformer transformer = factory.newTransformer(stylesheetSource);
		
		Source inputSource = new StreamSource(new File(inputPathname).getAbsoluteFile());
		
		Result outputResult = new StreamResult(new File(outputPathname).getAbsoluteFile());
		
		transformer.transform(inputSource, outputResult);
	}
}
