package gov.va.med.ars.spring.dao;


import gov.va.med.ars.exceptions.ArsDataAccessException;
import gov.va.med.ars.spring.model.ClaimAttachments;
import gov.va.med.ars.spring.model.UserAuthorization;
import gov.va.med.ars.util.DateUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
//import gov.va.med.ars.client.OException;
import org.springframework.jdbc.core.RowMapper;

/**
 * An implementation of the UserAuthorizationDao interface.
 *
 */
public class UserAuthorizationDaoImpl extends BaseDao implements UserAuthorizationDao {

	private JdbcTemplate jdbcTemplate;
	
	public UserAuthorizationDaoImpl(DataSource dataSource) {
		jdbcTemplate = new JdbcTemplate(dataSource);
	}
	
	static final Logger errorLogger = Logger.getLogger("errorLogger");

	@Override
	public void saveOrUpdate(UserAuthorization userAuthorization) {
		
			if( getUserAuth(userAuthorization.getUserId()) != null)
			{
				String sql = "UPDATE [Claim_Attachments].[dbo].UserAuthorization SET DOMAIN=?, STATUS=?, "
						+ "DOWNLOAD=?, EDIT=?, DEL=?, ADMIN=? WHERE USERID=?";
			jdbcTemplate.update(sql, userAuthorization.getDomain(), userAuthorization.getStatus(),
					userAuthorization.getDownload(), userAuthorization.getEdit(),
					userAuthorization.getDelete(), userAuthorization.getAdmin(), userAuthorization.getUserId());
			}
			else
			{
				String sql = "INSERT INTO [Claim_Attachments].[dbo].UserAuthorization (USERID, DOMAIN, STATUS, DOWNLOAD, EDIT, DEL, ADMIN ) " +
						" VALUES (?, ?, ?, ?, ?, ?, ?)";
				jdbcTemplate.update(sql, userAuthorization.getUserId(), userAuthorization.getDomain(),
						userAuthorization.getStatus(), userAuthorization.getDownload(), 
						userAuthorization.getEdit(), userAuthorization.getDelete(), userAuthorization.getAdmin());
			}
		
	}

	public void delete(String userId) {
		String sql = "UPDATE [Claim_Attachments].[dbo].UserAuthorization SET STATUS='D' WHERE USERID=?";
		jdbcTemplate.update(sql, userId);
	}
	

	@Override
	public List<UserAuthorization> list() {
		String sql = "SELECT * FROM [Claim_Attachments].[dbo].UserAuthorization WHERE status != 'D'";
		List<UserAuthorization> listUserAuthorization = jdbcTemplate.query(sql, new RowMapper<UserAuthorization>() {

			@Override
			public UserAuthorization mapRow(ResultSet rs, int rowNum) throws SQLException {
				try {
					UserAuthorization aUserAuthorization = new UserAuthorization();

					aUserAuthorization.setUserId(rs.getString("USERID"));
					aUserAuthorization.setDomain(rs.getString("DOMAIN"));
					aUserAuthorization.setStatus(rs.getString("STATUS"));
					aUserAuthorization.setDownload(rs.getString("DOWNLOAD"));
					aUserAuthorization.setEdit(rs.getString("EDIT"));
					aUserAuthorization.setDelete(rs.getString("DEL"));
					aUserAuthorization.setAdmin(rs.getString("ADMIN"));
					
					return aUserAuthorization;
				} catch (Exception e) {
					String message = "Unable to list UserAuthorization records : " + e.getMessage();
					errorLogger.error("Exception thrown when listing UserAuthorization records : " + e.getMessage() );
					throw new ArsDataAccessException(message ,e);
				}
			}
			
		});
		
		return listUserAuthorization;
	}
	
	@Override
	public UserAuthorization getUserAuth(String userId)
	{
		String sql = "SELECT * FROM [Claim_Attachments].[dbo].UserAuthorization WHERE USERID= '" + userId + "'";
		return jdbcTemplate.query(sql, new ResultSetExtractor<UserAuthorization>() {

			@Override
			public UserAuthorization extractData(ResultSet rs) throws SQLException,
					DataAccessException {
				if (rs.next()) {
					UserAuthorization userAuthorization = new UserAuthorization();
					userAuthorization.setUserId(rs.getString("USERID"));
					userAuthorization.setDomain(rs.getString("DOMAIN"));
					userAuthorization.setStatus(rs.getString("STATUS"));
					userAuthorization.setDownload(rs.getString("DOWNLOAD"));
					userAuthorization.setEdit(rs.getString("EDIT"));
					userAuthorization.setDelete(rs.getString("DEL"));
					userAuthorization.setAdmin(rs.getString("ADMIN"));

					return userAuthorization;
				}
				
				return null;
			}
			
		});
	}

}
