package gov.va.med.ars.spring.dao;


import gov.va.med.ars.spring.model.ClaimAttachments;
import gov.va.med.ars.spring.model.UserAuthorization;

import java.util.List;


/**
 * Defines DAO operations for the ClaimAttachments model.
 */
public interface ClaimAttachmentsDAO {
	
	public void saveOrUpdate(ClaimAttachments claimAttachment);
	
	public String downloadClaimAttachment(Integer id);
	
	public void delete(Integer id);
	
	public ClaimAttachments get(Integer id);
	
	public List<ClaimAttachments> list();
	
	public List<String> getCodedefinitions();
	
/*	public List<ClaimAttachments> searchClaimAttachments(String providerName,
            String providerIdentifier,
            String patientFirstName,
            String patientLastName,
            String claimServiceDate,
            String payerClaimControlNumber,
            String attachmentControlNumber);*/
	
	public List<ClaimAttachments> searchClaimAttachments(ClaimAttachments searchCriteria);
	
	public UserAuthorization getUserAuth(String userId);
	
	
}
