package gov.va.med.ars.spring.config;

import gov.va.med.ars.spring.dao.ClaimAttachmentsDAO;
import gov.va.med.ars.spring.dao.ClaimAttachmentsDAOImpl;
import gov.va.med.ars.spring.dao.DbLogManagerDao;
import gov.va.med.ars.spring.dao.DbLogManagerDaoImpl;
import gov.va.med.ars.spring.dao.UserAuthorizationDao;
import gov.va.med.ars.spring.dao.UserAuthorizationDaoImpl;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jndi.JndiTemplate;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
@ComponentScan(basePackages="gov.va.med.ars.spring")
@EnableWebMvc
//@ImportResource({"classpath:spring-security.xml"})
public class MvcConfiguration extends WebMvcConfigurerAdapter{
	
	@Bean
	public ViewResolver getViewResolver(){
		InternalResourceViewResolver resolver = new InternalResourceViewResolver();
		resolver.setPrefix("/WEB-INF/views/");
		resolver.setSuffix(".jsp");
		return resolver;
	}
	
	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		registry.addResourceHandler("/resources/**").addResourceLocations("/resources/");
	}

    @Override
    public void addViewControllers(final ViewControllerRegistry registry) {
        super.addViewControllers(registry);

        registry.addViewController("/anonymous.html");
        registry.addViewController("/login.html");
        registry.addViewController("/homepage.html");
    }
    
	@Bean
	public ClaimAttachmentsDAO getClaimAttachmentsDAO() throws NamingException {
		JndiTemplate jndiTemplate = new JndiTemplate();
		///DataSource dataSource = (DataSource) jndiTemplate.lookup("java:comp/env/jdbc/ArsDB");
		//return new ClaimAttachmentsDAOImpl(getDataSource());
		// Obtain our environment naming context 
		// Look up ARS data source
		DataSource dataSource = null;
		try {
			Context initCtx = new InitialContext(); 
			Context envCtx = (Context) initCtx.lookup("java:comp/env");
			dataSource = (DataSource) envCtx.lookup("jdbc/ArsDB");
			
			return new ClaimAttachmentsDAOImpl(dataSource);
		} catch (NamingException e1) 
		{
			
		    String url ="java:jdbc/ArsDB";
		    try {
		        dataSource = (DataSource) new InitialContext().lookup(url);
		    } catch (Exception e) 
		    {
		    	e.printStackTrace();
		    }
		    
		    System.out.println("Inside NamingException e1 returning ClaimAttachmentsDAOImpl(dataSource)");
		    
		    return new ClaimAttachmentsDAOImpl(dataSource);
		}
	}
	
	@Bean
	public UserAuthorizationDao getUserAuthorizationDao() throws NamingException {
		JndiTemplate jndiTemplate = new JndiTemplate();
		///DataSource dataSource = (DataSource) jndiTemplate.lookup("java:comp/env/jdbc/ArsDB");
		//return new ClaimAttachmentsDAOImpl(getDataSource());
		// Obtain our environment naming context 
		// Look up ARS data source
		DataSource dataSource = null;
		try {
			Context initCtx = new InitialContext(); 
			Context envCtx = (Context) initCtx.lookup("java:comp/env");
			dataSource = (DataSource) envCtx.lookup("jdbc/ArsDB");
			
			return new UserAuthorizationDaoImpl(dataSource);
		} catch (NamingException e1) 
		{
			
		    String url ="java:jdbc/ArsDB";
		    try {
		        dataSource = (DataSource) new InitialContext().lookup(url);
		    } catch (Exception e) 
		    {
		    	e.printStackTrace();
		    }
		    
		    System.out.println("Inside NamingException e1 returning UserAuthorizationDaoImpl(dataSource)");
		    
		    return new UserAuthorizationDaoImpl(dataSource);
		}
	}
		
	
/*	@Bean
	public ClaimAttachmentsDAO getClaimAttachmentsDAO() throws NamingException {
		JndiTemplate jndiTemplate = new JndiTemplate();
		///DataSource dataSource = (DataSource) jndiTemplate.lookup("java:comp/env/jdbc/ArsDB");
		return new ClaimAttachmentsDAOImpl(getDataSource());
		}*/
	
	
	@Bean
	public DbLogManagerDao getDbLogManagerDao() throws NamingException {
		JndiTemplate jndiTemplate = new JndiTemplate();
		//DataSource dataSource = (DataSource) jndiTemplate.lookup("java:comp/env/jdbc/ArsDB");
		//return new DbLogManagerDaoImpl(getDataSource());
		// Obtain our environment naming context 
		
		DataSource dataSource = null;
		try {
			Context initCtx = new InitialContext(); 
			Context envCtx = (Context) initCtx.lookup("java:comp/env");
			dataSource = (DataSource) envCtx.lookup("jdbc/ArsDB");
			
			return new DbLogManagerDaoImpl(dataSource);
		} catch (NamingException e1) 
		{
			
		    String url ="java:jdbc/ArsDB";
		    try {
		        dataSource = (DataSource) new InitialContext().lookup(url);
		    } catch (Exception e) 
		    {
		    	e.printStackTrace();
		    }
		    
		    System.out.println("Inside NamingException e1 returning DbLogManagerDaoImpl(dataSource)");
		    
		    return new DbLogManagerDaoImpl(dataSource);
		}
	}
	
	
/*	@Bean
	public DbLogManagerDao getDbLogManagerDao() throws NamingException {
		return new DbLogManagerDaoImpl(getDataSource());

	}*/
	
}
