package gov.va.med.ars.sec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

/**
 * Model representing the user.
 * 
 * @author Ian Meinert
 * @version 1.0 September 11, 2014
 */
public class AppUser {
		
	private String name;
	private String role;
	private Collection<String> roles;
	private String ntusername;

	public AppUser(String name, String role, String ntusername) {
		this.name = name;
		this.role = role;
		this.ntusername = ntusername;
		this.roles = new ArrayList<String>();
	}
	
	/**
	 * The authorities required for application access
	 * @return		collection of GrantedAuthorities build from the object's
	 * 				roles collection
	 */
	public Collection<? extends GrantedAuthority> getAuthorities() {
		Set<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
		if (roles != null && roles.size() > 0) {
			for(String role : roles) {
				authorities.add(new SimpleGrantedAuthority(role));
			}
		}
		
		return authorities;
	}

	public AppUser() {
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Collection<String> getRoles() {
		return roles;
	}

	public void setRoles(Collection<String> roles) {
		this.roles = roles;
	}
	
	public String getRole() {
		return role;
	}

	public void setRole(String role) {
		this.role = role;
	}
	
	public String getNtusername() {
		return ntusername;
	}

	public void setNtusername(String ntusername) {
		this.ntusername = ntusername;
	}
}
