USE [Claim_Attachments]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[ClaimAttachments](
	[Id] [int] IDENTITY(1,1) NOT NULL,
    [PROVIDER_NAME]	varchar(132),
    [PROVIDER_IDENTIFIER_NUMBER] varchar(20),
    [PATIENT_FIRST_NAME]	varchar(60),
	[PATIENT_LAST_NAME]	varchar(60),
	[REPORT_CODE] varchar(20),
	[PATIENT_CONTROL_NUMBER] varchar(20),
	[MEDICAL_RECORD_NUMBER] varchar(20),
    [PATIENT_IDENTIFIER_NUMBER] varchar(20),
	[PROVIDER_NPI] varchar(20),
    [CLAIM_IDENTIFIER] varchar(20),
    [CLAIM_SERVICE_DATE] date,
	[PAYER_CLAIM_CONTROL_NUMBER] varchar(20),
    [ATTACHMENT_CONTROL_NUMBER] varchar(20),
	[ATTACHMENT_NAME] varchar(60),
	[ATTACHMENT_TYPE] varchar(10) NOT NULL,
	LOINC_CODE varchar(100), 
	[STATUS] varchar(10) NOT NULL,
	[Ver] [int] NOT NULL,
 CONSTRAINT attachment_type_chk_val CHECK (ATTACHMENT_TYPE IN ('TXT','PDF','JPG', 'XML')),
 CONSTRAINT [PK_ClaimAttachments] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[ClaimAttachments] ADD  CONSTRAINT [DF_ClaimAttachments_Ver]  DEFAULT (1) FOR [Ver]
GO

ALTER TABLE [dbo].[ClaimAttachments]  WITH CHECK ADD  CONSTRAINT [FK_ReportType] FOREIGN KEY([REPORT_CODE])
REFERENCES [dbo].[ArsReportType] ([CODE])


