/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.util;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class FMDateUtils {
    public static Date fmDateTimeToDate(String fmDate) {
        return FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)fmDate, (double)0.0));
    }

    public static Date fmDateTimeToDate(double fmDate) {
        String datePart = StringUtils.piece((String)String.valueOf(fmDate), (char)'.', (int)1);
        String timePart = StringUtils.piece((String)String.valueOf(fmDate), (char)'.', (int)2);
        if (datePart.length() != 7) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Integer.valueOf(datePart.substring(0, 3)) + 1700, Integer.valueOf(datePart.substring(3, 5)) - 1, Integer.valueOf(datePart.substring(5, 7)));
        if (timePart.length() == 2 && timePart.substring(0, 2).equals("24")) {
            timePart = "235959";
        }
        for (int i = timePart.length(); i < 6; ++i) {
            timePart = timePart + "0";
        }
        if (timePart.length() == 6) {
            calendar.set(11, Integer.valueOf(timePart.substring(0, 2)));
            calendar.set(12, Integer.valueOf(timePart.substring(2, 4)));
            calendar.set(13, Integer.valueOf(timePart.substring(4, 6)));
        }
        return calendar.getTime();
    }

    public static String fmDateTimeToAnsiDateTime(double fmDate) throws ParseException {
        return DateUtils.toAnsiDateTime((Date)FMDateUtils.fmDateTimeToDate(fmDate));
    }

    public static String fmDateToAnsiDate(double fmDate) throws ParseException {
        return DateUtils.toAnsiDate((Date)FMDateUtils.fmDateTimeToDate(fmDate));
    }

    public static String fmDateTimeToEnglishDateTime(double fmDate) throws ParseException {
        return DateUtils.toDateTimeStr((Date)FMDateUtils.fmDateTimeToDate(fmDate), (String)DateUtils.ENGLISH_SHORT_DATE_TIME_FORMAT2);
    }

    public static String fmDateToEnglishDate(double fmDate) throws ParseException {
        return DateUtils.toEnglishDate((Date)FMDateUtils.fmDateTimeToDate(fmDate));
    }

    public static double dateTimeToFMDateTime(Calendar dateTime) {
        int y = dateTime.get(1);
        int m = dateTime.get(2);
        int d = dateTime.get(5);
        int h = dateTime.get(11);
        int n = dateTime.get(12);
        int s = dateTime.get(13);
        int datePart = (y - 1700) * 10000 + (m + 1) * 100 + d;
        int timePart = h * 10000 + n * 100 + s;
        return (double)datePart + (double)timePart / 1000000.0;
    }

    public static double dateTimeToFMDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return FMDateUtils.dateTimeToFMDateTime(calendar);
    }

    public static double dateToFMDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int y = calendar.get(1);
        int m = calendar.get(2);
        int d = calendar.get(5);
        int datePart = (y - 1700) * 10000 + (m + 1) * 100 + d;
        return datePart;
    }

    public static double ansiDateTimeToFMDateTime(String ansiDateTime) throws ParseException {
        GregorianCalendar cal = DateUtils.convertAnsiDateTimeStrToCalendar((String)ansiDateTime);
        return FMDateUtils.dateTimeToFMDateTime(cal);
    }

    public static double ansiDateToFMDate(String ansiDate) throws ParseException {
        Date dt = DateUtils.convertAnsiDateStr((String)ansiDate);
        return FMDateUtils.dateToFMDate(dt);
    }
}

