/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.user.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.data.ListItem;
import gov.va.med.lom.vistabroker.user.data.Employee;
import gov.va.med.lom.vistabroker.user.data.VistaUser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VistaUserDao
extends BaseDao {
    private static final Log log = LogFactory.getLog(VistaUserDao.class);

    public VistaUserDao() {
    }

    public VistaUserDao(BaseDao baseDao) {
        super(baseDao);
    }

    public VistaUser getVistaUser() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU USERINFO");
        VistaUser vistaUser = new VistaUser();
        String x = this.sCall();
        vistaUser.setDuz(StringUtils.piece((String)x, (int)1));
        vistaUser.setUserClass(StringUtils.toInt((String)StringUtils.piece((String)x, (int)3), (int)0));
        vistaUser.setCanSignOrders(StringUtils.piece((String)x, (int)4).equals("1"));
        vistaUser.setProvider(StringUtils.piece((String)x, (int)5).equals("1"));
        vistaUser.setOrderRole(StringUtils.toInt((String)StringUtils.piece((String)x, (int)6), (int)0));
        vistaUser.setNoOrdering(StringUtils.piece((String)x, (int)7).equals("1"));
        vistaUser.setDTime(StringUtils.toInt((String)StringUtils.piece((String)x, (int)8), (int)300));
        vistaUser.setCountDown(StringUtils.toInt((String)StringUtils.piece((String)x, (int)9), (int)10));
        vistaUser.setEnableVerify(StringUtils.piece((String)x, (int)10).equals("1"));
        vistaUser.setNotifyAppsWM(StringUtils.piece((String)x, (int)11).equals("1"));
        vistaUser.setPtMsgHang(StringUtils.toInt((String)StringUtils.piece((String)x, (int)12), (int)5));
        vistaUser.setDomain(StringUtils.piece((String)x, (int)13));
        vistaUser.setService(StringUtils.toInt((String)StringUtils.piece((String)x, (int)14), (int)0));
        vistaUser.setAutoSave(StringUtils.toInt((String)StringUtils.piece((String)x, (int)15), (int)180));
        vistaUser.setInitialTab(StringUtils.toInt((String)StringUtils.piece((String)x, (int)16), (int)1));
        vistaUser.setUseLastTab(StringUtils.piece((String)x, (int)17).equals("1"));
        vistaUser.setWebAccess(!StringUtils.piece((String)x, (int)18).equals("1"));
        vistaUser.setDisableHold(StringUtils.piece((String)x, (int)19).equals("1"));
        vistaUser.setIsRPL(StringUtils.piece((String)x, (int)20));
        vistaUser.setRplList(StringUtils.piece((String)x, (int)21));
        vistaUser.setHasCorTabs(StringUtils.piece((String)x, (int)22).equals("1"));
        vistaUser.setHasRptTab(StringUtils.piece((String)x, (int)23).equals("1"));
        vistaUser.setReportsOnly(false);
        this.setDefaultRpcName("XUS GET USER INFO");
        List<String> list = this.lCall();
        if (list.size() >= 8) {
            vistaUser.setName(list.get(1));
            vistaUser.setStandardName(list.get(2));
            String division = list.get(3);
            vistaUser.setStationIen(StringUtils.piece((String)division, (int)1));
            vistaUser.setStation(StringUtils.piece((String)division, (int)2));
            vistaUser.setStationNumber(StringUtils.piece((String)division, (int)3));
            vistaUser.setTitle(list.get(4));
            vistaUser.setServiceSection(list.get(5));
            int language = 0;
            try {
                language = Integer.valueOf(list.get(6));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            vistaUser.setLanguage(language);
        }
        return vistaUser;
    }

    public String getUserParam(String paramName) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU PARAM");
        Object[] params = new Object[]{paramName};
        String x = this.sCall(params);
        return x;
    }

    public boolean hasSecurityKey(String keyName) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU HASKEY");
        Object[] params = new Object[]{keyName};
        String x = this.sCall(params);
        return x.equals("1");
    }

    public boolean hasKey(String keyName) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU NPHASKEY");
        Object[] params = new Object[]{keyName};
        String x = this.sCall(params);
        return x.equals("1");
    }

    public boolean hasMenuOptionAccess(String optionName) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU HAS OPTION ACCESS");
        Object[] params = new Object[]{optionName};
        String x = this.sCall(params);
        return x.equals("1");
    }

    public boolean userInactive(String duz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU USER INACTIVE?");
        String x = this.sCall(duz);
        return !x.equals("0");
    }

    public Employee getEmployeeByDuz(String duz) throws Exception {
        this.setDefaultContext("ALT INTRANET RPCS");
        this.setDefaultRpcName("ALSI EMI EMPLOYEE GET");
        String x = this.sCall(duz);
        return this.stringToEmployee(x);
    }

    public List<ListItem> getEmployeesForTL(String tlCode) throws Exception {
        this.setDefaultContext("ALT INTRANET RPCS");
        this.setDefaultRpcName("ALSI EMI EMPLOYEES BY TL");
        List<String> x = this.lCall(tlCode);
        ArrayList<ListItem> l = new ArrayList<ListItem>();
        if (x == null) {
            return l;
        }
        for (String y : x) {
            ListItem i = new ListItem();
            i.setIen(StringUtils.piece((String)y, (int)2));
            i.setName(StringUtils.piece((String)y, (int)3));
            l.add(i);
        }
        return l;
    }

    public List<ListItem> getTLForSupervisor(String duz) throws Exception {
        this.setDefaultContext("ALT INTRANET RPCS");
        this.setDefaultRpcName("ALSI EMI SUPERVISOR TL");
        List<String> x = this.lCall(duz);
        ArrayList<ListItem> l = new ArrayList<ListItem>();
        if (x == null) {
            return l;
        }
        for (String y : x) {
            ListItem i = new ListItem();
            i.setIen(StringUtils.piece((String)y, (int)2));
            i.setName(StringUtils.piece((String)y, (int)3));
            l.add(i);
        }
        return l;
    }

    public List<Employee> searchEmployeesByName(String name, Boolean activeOnly, Boolean paidOnly, Integer maxResults) throws Exception {
        ArrayList<Employee> l = new ArrayList<Employee>();
        this.setDefaultContext("ALT INTRANET RPCS");
        this.setDefaultRpcName("ALSI EMI EMPLOYEE SEARCH");
        Object[] params = new Object[]{name.toUpperCase(), activeOnly != false ? "1" : "0", paidOnly != false ? "1" : "0", maxResults.toString()};
        List<String> s = this.lCall(params);
        for (String x : s) {
            Employee employee = new Employee();
            employee.setStationNo(StringUtils.piece((String)x, (int)1));
            employee.setDuz(StringUtils.piece((String)x, (int)2));
            employee.setSsn(StringUtils.piece((String)x, (int)3));
            employee.setName(StringUtils.piece((String)x, (int)4));
            employee.setTitle(StringUtils.piece((String)x, (int)5));
            String termDate = StringUtils.piece((String)x, (int)6);
            if (termDate != null && termDate.length() > 0) {
                try {
                    employee.setTerminationDate(DateUtils.convertEnglishDateStr((String)termDate));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            employee.setExtension(StringUtils.piece((String)x, (int)7));
            employee.setRoom(StringUtils.piece((String)x, (int)8));
            String lastSign = StringUtils.piece((String)x, (int)13);
            if (lastSign != null && lastSign.length() > 0) {
                try {
                    employee.setLastSignon(DateUtils.convertEnglishDateStr((String)lastSign));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            l.add(employee);
        }
        return l;
    }

    private Employee stringToEmployee(String x) {
        Employee employee = new Employee();
        employee.setStationNo(StringUtils.piece((String)x, (int)1));
        employee.setDuz(StringUtils.piece((String)x, (int)2));
        employee.setName(StringUtils.piece((String)x, (int)3));
        employee.setTitle(StringUtils.piece((String)x, (int)4));
        employee.setExtension(StringUtils.piece((String)x, (int)5));
        employee.setPager(StringUtils.piece((String)x, (int)6));
        employee.setRoom(StringUtils.piece((String)x, (int)7));
        String s = StringUtils.piece((String)x, (int)8);
        if (s != null && s.length() > 0) {
            try {
                employee.setTerminationDate(DateUtils.convertEnglishDateStr((String)s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        employee.setSsn(StringUtils.piece((String)x, (int)9));
        employee.setMailCode(StringUtils.piece((String)x, (int)11));
        s = StringUtils.piece((String)x, (int)12);
        if (s != null && s.length() > 0) {
            employee.setPaidId(Long.parseLong(s));
        }
        if ((s = StringUtils.piece((String)x, (int)13)) != null && s.length() > 0) {
            try {
                employee.setLastSignon(DateUtils.convertEnglishDateStr((String)s));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        employee.setServiceIen(StringUtils.piece((String)x, (int)14));
        employee.setDegree(StringUtils.piece((String)x, (int)15));
        employee.setProgram(StringUtils.piece((String)x, (int)16));
        return employee;
    }
}

