/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.user.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.user.data.Notification;
import gov.va.med.lom.vistabroker.user.data.TiuAlertInfo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationsDao
extends BaseDao {
    public NotificationsDao() {
    }

    public NotificationsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Notification> getNotifications() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORB FASTUSER");
        List<String> list = this.lCall();
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        for (String x : list) {
            Notification notification = new Notification();
            notification = new Notification();
            notification.setInfo(StringUtils.piece((String)x, (int)1));
            if (!StringUtils.piece((String)x, (char)'^', (int)1).equalsIgnoreCase("Forwarded by:")) {
                block13: for (int j = 2; j <= StringUtils.getCharCount((String)x, (char)'^') + 1; ++j) {
                    String y = StringUtils.piece((String)x, (int)j);
                    switch (j) {
                        case 2: {
                            notification.setPatient(y);
                            continue block13;
                        }
                        case 3: {
                            notification.setLocation(y);
                            continue block13;
                        }
                        case 4: {
                            notification.setUrgency(y);
                            continue block13;
                        }
                        case 5: {
                            try {
                                Date dt = DateUtils.toDate((String)y, (String)DateUtils.ANSI_SHORT_DATE_TIME_FORMAT2);
                                notification.setAlertDateTime(dt);
                                notification.setAlertDateTimeStr(y);
                            }
                            catch (ParseException pe) {}
                            continue block13;
                        }
                        case 6: {
                            notification.setText(y);
                            continue block13;
                        }
                        case 7: {
                            notification.setForwardingInfo(y);
                            continue block13;
                        }
                        case 8: {
                            notification.setXqaid(y);
                            notification.setOrderInfo(StringUtils.piece((String)y, (char)';', (int)1));
                            notification.setDfn(StringUtils.piece((String)y, (char)';', (int)2));
                            notification.setOrderType(StringUtils.piece((String)StringUtils.piece((String)y, (char)';', (int)1), (char)',', (int)1));
                            String s = StringUtils.piece((String)y, (char)';', (int)1);
                            s = StringUtils.piece((String)s.substring(3, s.length()), (char)',', (int)1);
                            notification.setIen(s);
                            notification.setFollowUp(StringUtils.piece((String)StringUtils.piece((String)y, (char)';', (int)1), (char)',', (int)3));
                            continue block13;
                        }
                        case 10: {
                            notification.setComment(y);
                        }
                    }
                }
            } else {
                notification.setForwardingInfo(StringUtils.piece((String)x, (int)2));
                String y = StringUtils.piece((String)x, (int)3);
                if (y.length() > 0) {
                    y = "Fwd Comment: " + y;
                }
                notification.setComment(y);
            }
            if (notification.getInfo().length() == 0) {
                String z = StringUtils.piece((String)notification.getXqaid(), (char)',', (int)1);
                if (z.length() > 3) {
                    z = z.substring(0, 3);
                }
                notification.setInfo(z);
            }
            notifications.add(notification);
        }
        return notifications;
    }

    public String getXQAData(String xqaid) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORB GETDATA");
        return this.sCall(xqaid);
    }

    public String getNotificationFollowUpText(String dfn, String ien, String xqaData) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORB TEXT FOLLOWUP");
        Object[] params = new Object[]{dfn, ien, xqaData};
        List<String> list = this.lCall(params);
        StringBuffer results = new StringBuffer();
        for (String s : list) {
            results.append(s + '\n');
        }
        return results.toString().trim();
    }

    public TiuAlertInfo getTIUAlertInfo(String xqaid) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU GET ALERT INFO");
        String x = this.sCall(xqaid);
        TiuAlertInfo tiuAlertInfo = new TiuAlertInfo();
        tiuAlertInfo.setTiuda(StringUtils.piece((String)x, (int)1));
        tiuAlertInfo.setDfn(StringUtils.piece((String)x, (int)2));
        tiuAlertInfo.setGuiTabIndicator(StringUtils.piece((String)x, (int)3));
        return tiuAlertInfo;
    }

    public boolean deleteAlert(String xqaid) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORB DELETE ALERT");
        String x = this.sCall(xqaid);
        return StringUtils.strToBool((String)x, (String)"true");
    }

    public String forwardAlert(String xqaid, String duz, String fwdType, String comment) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORB FORWARD ALERT");
        Object[] params = new Object[]{xqaid, duz, fwdType, comment};
        return this.sCall(params);
    }
}

