/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.user.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.user.data.ActionResult;
import gov.va.med.lom.vistabroker.user.data.Signer;
import gov.va.med.lom.vistabroker.util.Hash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectronicSignatureDao
extends BaseDao {
    public ElectronicSignatureDao() {
    }

    public ElectronicSignatureDao(BaseDao baseDao) {
        super(baseDao);
    }

    public ActionResult actOnDocument(String ien, String actionName) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU AUTHORIZATION");
        Object[] params = new Object[]{ien, actionName};
        String x = this.sCall(params);
        ActionResult actionResult = new ActionResult();
        actionResult.setSuccess(StringUtils.piece((String)x, (int)1).equals("1"));
        actionResult.setMessage(StringUtils.piece((String)x, (int)2));
        return actionResult;
    }

    public boolean canChangeCosigner(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU CAN CHANGE COSIGNER?");
        String x = this.sCall(ien);
        return StringUtils.piece((String)x, (int)1).equals("1");
    }

    public boolean authorSignedDocument(String ien, String duz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU HAS AUTHOR SIGNED?");
        Object[] params = new Object[]{ien, duz};
        String x = this.sCall(params);
        return StringUtils.piece((String)x, (int)1).equals("1");
    }

    public boolean canCosign(String titleIen, int docType, String duz) throws Exception {
        Object[] params;
        String x;
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU REQUIRES COSIGNATURE");
        if (!titleIen.equals("0")) {
            docType = 0;
        }
        return !StringUtils.piece((String)(x = this.sCall(params = new Object[]{titleIen, docType, duz})), (int)1).equals("1");
    }

    public boolean tiuRequiresCosignature(int docType, String duz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU REQUIRES COSIGNATURE");
        Object[] params = new Object[]{docType, 0, duz};
        String x = this.sCall(params);
        return StringUtils.piece((String)x, (int)1).equals("1");
    }

    public boolean mustCosignDocument(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU WHICH SIGNATURE ACTION");
        String x = this.sCall(ien);
        return x.equalsIgnoreCase("COSIGNATURE");
    }

    public boolean isValidElectronicSignatureCode(String code) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU VALIDSIG");
        Object[] params = new Object[]{Hash.encrypt(code)};
        String x = this.sCall(params);
        return x.equals("1");
    }

    public List<Signer> getCurrentSigners(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU GET ADDITIONAL SIGNERS");
        List<String> list = this.lCall(ien);
        ArrayList<Signer> signers = new ArrayList<Signer>();
        for (String s : list) {
            Signer signer = new Signer();
            signer.setDuz(StringUtils.piece((String)s, (int)1));
            signer.setName(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)));
            signer.setComment(StringUtils.piece((String)s, (int)3));
            signer.setRpcResult(s);
            signers.add(signer);
        }
        return signers;
    }

    public List<Signer> updateAdditionalSigners(String ien, List<Signer> signersList) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU UPDATE ADDITIONAL SIGNERS");
        ArrayList<String> duzList = new ArrayList<String>();
        for (Signer signer : signersList) {
            duzList.add(signer.getDuz());
        }
        Object[] params = new Object[]{ien, duzList};
        List<String> list = this.lCall(params);
        ArrayList<Signer> signers = new ArrayList<Signer>();
        for (String s : list) {
            Signer signer = new Signer();
            signer.setDuz(StringUtils.piece((String)s, (int)1));
            signer.setName(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)));
            signer.setComment(StringUtils.piece((String)s, (int)3));
            signer.setRpcResult(s);
            signers.add(signer);
        }
        return signers;
    }

    public String changeCosigner(String ien, String cosignerDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU UPDATE RECORD");
        HashMap<String, String> map = new HashMap<String, String>();
        if (!cosignerDuz.equals("0")) {
            map.put("1208", String.valueOf(cosignerDuz));
        } else {
            map.put("1208", "@");
        }
        Object[] params = new Object[]{ien, map};
        String x = this.sCall(params);
        return StringUtils.piece((String)x, (int)2);
    }

    public ActionResult signDocument(String ien, String esCode) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU SIGN RECORD");
        Object[] params = new Object[]{ien, Hash.encrypt(esCode)};
        String x = this.sCall(params);
        ActionResult actionResult = new ActionResult();
        actionResult.setSuccess(StringUtils.piece((String)x, (int)1).equals("1"));
        actionResult.setMessage(StringUtils.piece((String)x, (int)2));
        return actionResult;
    }

    public ActionResult tiuAdminClose(String noteIen, String mode, String userDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU SET ADMINISTRATIVE CLOSURE");
        Object[] params = new Object[]{noteIen, mode, userDuz};
        String x = this.sCall(params);
        ActionResult actionResult = new ActionResult();
        actionResult.setSuccess(!StringUtils.piece((String)x, (int)1).equals("0"));
        actionResult.setMessage(StringUtils.piece((String)x, (int)2));
        return actionResult;
    }
}

