/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.service.impl;

import gov.va.med.lom.foundation.service.response.CollectionServiceResponse;
import gov.va.med.lom.foundation.service.response.ServiceResponse;
import gov.va.med.lom.vistabroker.lists.dao.CodesDao;
import gov.va.med.lom.vistabroker.lists.dao.CoverSheetListDao;
import gov.va.med.lom.vistabroker.lists.dao.LabTestTypesDao;
import gov.va.med.lom.vistabroker.lists.dao.LocationsDao;
import gov.va.med.lom.vistabroker.lists.dao.NoteTitlesDao;
import gov.va.med.lom.vistabroker.lists.dao.OrderItemsDao;
import gov.va.med.lom.vistabroker.lists.dao.PersonsDao;
import gov.va.med.lom.vistabroker.lists.dao.ProceduresDao;
import gov.va.med.lom.vistabroker.lists.dao.ServicesDao;
import gov.va.med.lom.vistabroker.lists.dao.SpecialtiesTeamsDao;
import gov.va.med.lom.vistabroker.lists.dao.StatusUrgenciesDao;
import gov.va.med.lom.vistabroker.lists.data.CoverSheetRpc;
import gov.va.med.lom.vistabroker.lists.data.CptCode;
import gov.va.med.lom.vistabroker.lists.data.Icd9Code;
import gov.va.med.lom.vistabroker.lists.data.ListItem;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import gov.va.med.lom.vistabroker.service.ListsVBService;
import gov.va.med.lom.vistabroker.service.impl.BaseService;
import java.io.Serializable;
import java.util.Date;
import javax.ejb.Remote;
import javax.ejb.Stateless;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="gov.va.med.lom.vistabroker.ListsVBService")
@Remote(value={ListsVBService.class})
public class ListsVBServiceImpl
extends BaseService
implements ListsVBService,
Serializable {
    @Override
    public CollectionServiceResponse<Icd9Code> listICD9Codes(ISecurityContext securityContext, String dsix, String scr) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dsix, scr};
        return this.collectionResult(Icd9Code.class, CodesDao.class, "listICD9Codes", params);
    }

    @Override
    public CollectionServiceResponse<Icd9Code> listIcd9Lexicon(ISecurityContext securityContext, String lex, double dt) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{lex, dt};
        return this.collectionResult(Icd9Code.class, CodesDao.class, "listIcd9Lexicon", params);
    }

    @Override
    public CollectionServiceResponse<CptCode> listCPTCodes(ISecurityContext securityContext, String val) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(CptCode.class, CodesDao.class, "listCPTCodes", val);
    }

    @Override
    public CollectionServiceResponse<CptCode> listCptLexicon(ISecurityContext securityContext, String lex, double dt) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{lex, dt};
        return this.collectionResult(CptCode.class, CodesDao.class, "listCptLexicon", params);
    }

    @Override
    public ServiceResponse<String> lexiconToIcd9Code(ISecurityContext securityContext, String ien, double dt) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, dt};
        return this.singleResult(String.class, CodesDao.class, "lexiconToIcd9Code", params);
    }

    @Override
    public ServiceResponse<String> lexiconToCptCode(ISecurityContext securityContext, String ien, double dt) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, dt};
        return this.singleResult(String.class, CodesDao.class, "lexiconToCptCode", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> listAllSpecialties(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, SpecialtiesTeamsDao.class, null, "listAllSpecialties");
    }

    @Override
    public CollectionServiceResponse<ListItem> listAllTeams(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, SpecialtiesTeamsDao.class, "listAllTeams");
    }

    @Override
    public CollectionServiceResponse<CoverSheetRpc> getCoverSheetList(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(CoverSheetRpc.class, CoverSheetListDao.class, "getCoverSheetList");
    }

    @Override
    public CollectionServiceResponse<ListItem> getAtomicTests(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getAtomicTests", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSpecimens(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getSpecimens", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getAllTests(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getAllTests", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getChemTests(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getChemTests", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getLabUsers(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getLabUsers", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getTestGroupsForLabUser(ISecurityContext securityContext, String userDuz) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getTestGroupsForLabUser", userDuz);
    }

    @Override
    public CollectionServiceResponse<ListItem> getATest(ISecurityContext securityContext, String testIen) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getATest", testIen);
    }

    @Override
    public CollectionServiceResponse<ListItem> getATestGroup(ISecurityContext securityContext, String testGroupIen, String userDuz) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{testGroupIen, userDuz};
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getATestGroup", params);
    }

    @Override
    public ServiceResponse<String> getTestInfo(ISecurityContext securityContext, String testIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, LabTestTypesDao.class, "getTestInfo", testIen);
    }

    @Override
    public CollectionServiceResponse<ListItem> getLabReportLists(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, LabTestTypesDao.class, "getLabReportLists");
    }

    @Override
    public CollectionServiceResponse<ListItem> listAllWards(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, LocationsDao.class, "listAllWards");
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfLocations(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LocationsDao.class, "getSubSetOfLocations", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfInpatientLocations(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LocationsDao.class, "getSubSetOfInpatientLocations", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfNewLocations(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LocationsDao.class, "getSubSetOfNewLocations", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> listAllClinics(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, LocationsDao.class, "listAllClinics");
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfClinics(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, LocationsDao.class, "getSubSetOfClinics", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getTitlesForClass(ISecurityContext securityContext, String classIen, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{classIen, startFrom, direction};
        return this.collectionResult(ListItem.class, NoteTitlesDao.class, "getTitlesForClass", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> subsetOfProgressNoteTitles(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, NoteTitlesDao.class, "subsetOfProgressNoteTitles", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> subSetOfDCSummaryTitles(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, NoteTitlesDao.class, "subSetOfDCSummaryTitles", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> subSetOfClinProcTitles(ISecurityContext securityContext, String startFrom, int direction, boolean idNoteTitlesOnly) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction, idNoteTitlesOnly};
        return this.collectionResult(ListItem.class, NoteTitlesDao.class, "subSetOfClinProcTitles", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfOrderItems(ISecurityContext securityContext, String startFrom, int direction, String xRef) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction, xRef};
        return this.collectionResult(ListItem.class, OrderItemsDao.class, "getSubSetOfOrderItems", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfPersons(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfPersons", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfProviders(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfProviders", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfProvidersWithClass(ISecurityContext securityContext, String startFrom, int direction, Date dateTime) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction, dateTime};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfProvidersWithClass", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> listProvidersAll(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, PersonsDao.class, "listProvidersAll");
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfUsers(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfUsers", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfUsersByType(ISecurityContext securityContext, String startFrom, int direction, String type) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction, type};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfUsersByType", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfUsersWithClass(ISecurityContext securityContext, String startFrom, int direction, String dateTime) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction, dateTime};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfUsersWithClass", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfActiveAndInactivePersons(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfActiveAndInactivePersons", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfAttendings(ISecurityContext securityContext, String startFrom, int direction, Date dateTime, String docTypeIen, String docIen) throws Exception {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction, dateTime, docTypeIen, docIen};
        return this.collectionResult(ListItem.class, PersonsDao.class, "getSubSetOfAttendings", params);
    }

    @Override
    public CollectionServiceResponse<String> odForProcedures(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(String.class, ProceduresDao.class, "odForProcedures");
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfProcedures(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, ProceduresDao.class, "getSubSetOfProcedures", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getServiceList(ISecurityContext securityContext, int purpose) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, ServicesDao.class, "getServiceList", purpose);
    }

    @Override
    public CollectionServiceResponse<ListItem> getServiceListWithSynonyms(ISecurityContext securityContext, int purpose, String consultIen) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{purpose, consultIen};
        return this.collectionResult(ListItem.class, ServicesDao.class, "getServiceListWithSynonyms", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> getSubSetOfServices(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(ListItem.class, ServicesDao.class, "getSubSetOfServices", params);
    }

    @Override
    public CollectionServiceResponse<ListItem> subSetOfStatus(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, StatusUrgenciesDao.class, "subSetOfStatus");
    }

    @Override
    public CollectionServiceResponse<ListItem> subSetOfUrgencies(ISecurityContext securityContext, String consultIen) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ListItem.class, StatusUrgenciesDao.class, "subSetOfUrgencies", consultIen);
    }
}

