/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.service.impl;

import gov.va.med.lom.foundation.service.response.CollectionServiceResponse;
import gov.va.med.lom.foundation.service.response.ServiceResponse;
import gov.va.med.lom.vistabroker.ddr.DdrFiler;
import gov.va.med.lom.vistabroker.ddr.DdrGetsEntry;
import gov.va.med.lom.vistabroker.ddr.DdrLister;
import gov.va.med.lom.vistabroker.ddr.DdrParams;
import gov.va.med.lom.vistabroker.ddr.DdrValidator;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import gov.va.med.lom.vistabroker.service.DdrVBService;
import gov.va.med.lom.vistabroker.service.impl.BaseService;
import java.io.Serializable;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="gov.va.med.lom.vistabroker.DdrVBService")
@Remote(value={DdrVBService.class})
public class DdrVBServiceImpl
extends BaseService
implements DdrVBService,
Serializable {
    @Override
    public ServiceResponse<String> execDdrFiler(ISecurityContext securityContext, String operation, String[] args) {
        ServiceResponse response = new ServiceResponse();
        try {
            DdrFiler ddrFiler = new DdrFiler(securityContext);
            ddrFiler.setOperation(operation);
            ddrFiler.setArgs(args);
            String result = ddrFiler.execute();
            response.setPayload((Object)result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public CollectionServiceResponse<String> execDdrGetsEntry(ISecurityContext securityContext, String file, String iens, String fields, String flags) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            DdrGetsEntry dDdrGetsEntry = new DdrGetsEntry(securityContext);
            dDdrGetsEntry.setFile(file);
            dDdrGetsEntry.setIens(iens);
            dDdrGetsEntry.setFields(fields);
            dDdrGetsEntry.setFlags(flags);
            List<String> result = dDdrGetsEntry.execute();
            response.setCollection(result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public CollectionServiceResponse<String> execDdrLister(ISecurityContext securityContext, String file, String iens, String fields, String flags, Integer max, String from, String part, String xref, String screen, String id, String options, String moreFrom, String moreIens) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            DdrLister ddrLister = new DdrLister(securityContext);
            ddrLister.setFile(file);
            ddrLister.setIens(iens);
            ddrLister.setFields(fields);
            ddrLister.setFlags(flags);
            ddrLister.setMax(max);
            ddrLister.setFrom(from);
            ddrLister.setPart(part);
            ddrLister.setXref(xref);
            ddrLister.setScreen(screen);
            ddrLister.setId(id);
            ddrLister.setOptions(options);
            ddrLister.setMoreFrom(moreFrom);
            ddrLister.setMoreIens(moreIens);
            List<String> result = ddrLister.execute();
            response.setCollection(result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public ServiceResponse<String> execDdrValidator(ISecurityContext securityContext, String file, String iens, String field, String value) {
        ServiceResponse response = new ServiceResponse();
        try {
            DdrValidator ddrValidator = new DdrValidator(securityContext);
            ddrValidator.setFile(file);
            ddrValidator.setIens(iens);
            ddrValidator.setField(field);
            ddrValidator.setValue(value);
            String result = ddrValidator.execute();
            response.setPayload((Object)result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public CollectionServiceResponse<String> execDdrGetsEntry(ISecurityContext securityContext, DdrParams ddrParams) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            DdrGetsEntry ddrGetsEntry = new DdrGetsEntry(securityContext);
            List<String> result = ddrGetsEntry.execute(ddrParams);
            response.setCollection(result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public CollectionServiceResponse<String> execDdrLister(ISecurityContext securityContext, DdrParams ddrParams) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            DdrLister ddrLister = new DdrLister(securityContext);
            List<String> result = ddrLister.execute(ddrParams);
            response.setCollection(result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public ServiceResponse<String> execDdrValidator(ISecurityContext securityContext, DdrParams ddrParams) {
        ServiceResponse response = new ServiceResponse();
        try {
            DdrValidator ddrValidator = new DdrValidator(securityContext);
            String result = ddrValidator.execute(ddrParams);
            response.setPayload((Object)result);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public CollectionServiceResponse<String> execIenNameQuery(ISecurityContext securityContext, String fileNumber) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            DdrLister ddrLister = DdrLister.buildIenNameQuery(securityContext, fileNumber);
            List<String> results = ddrLister.execute();
            response.setCollection(results);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }

    @Override
    public CollectionServiceResponse<String> execFileQuery(ISecurityContext securityContext, String fileNumber, String fieldString) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            DdrLister ddrLister = DdrLister.buildFileQuery(securityContext, fileNumber, fieldString);
            List<String> results = ddrLister.execute();
            response.setCollection(results);
        }
        catch (Exception ex) {
            response.addError(ex.getMessage());
        }
        return response;
    }
}

