/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.service.impl;

import gov.va.med.lom.foundation.service.response.CollectionServiceResponse;
import gov.va.med.lom.foundation.service.response.ServiceResponse;
import gov.va.med.lom.javaUtils.misc.ReflectUtil;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.exception.VistaBrokerException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerSecurityException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerSocketTimeoutException;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import gov.va.med.lom.vistabroker.service.Service;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseService
implements Service {
    protected String defaultContext = null;
    protected String rpcName = null;
    protected ISecurityContext securityContext = null;
    protected boolean logEvent = true;
    protected BaseDao baseDao = null;
    protected InitialContext ctx;
    protected static final Log log = LogFactory.getLog(BaseService.class);

    public void setSecurityContext(ISecurityContext securityContext) {
        if (securityContext != null && securityContext.getType() >= 1 && securityContext.getType() <= 5) {
            this.securityContext = securityContext;
        }
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public String getRpcName() {
        return this.rpcName;
    }

    public void setRpcName(String rpcName) {
        this.rpcName = rpcName;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public String getResults() {
        if (this.baseDao != null) {
            return this.baseDao.getResults();
        }
        return null;
    }

    public String getResultType() {
        if (this.baseDao != null) {
            return this.baseDao.getResultType();
        }
        return null;
    }

    public Document getDocument() throws Exception {
        if (this.baseDao != null) {
            return this.baseDao.getDocument();
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    protected void setLogEvent(boolean logEvent) {
        this.logEvent = logEvent;
    }

    protected Object invokeCall(Class daoClass, String methodName) throws VistaBrokerException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] args = new Object[]{};
        return this.invokeCall(daoClass, methodName, args);
    }

    protected Object invokeCall(Class daoClass, String methodName, Object arg) throws VistaBrokerException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] args = new Object[]{arg};
        return this.invokeCall(daoClass, methodName, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeCall(Class daoClass, String methodName, Object[] args) throws VistaBrokerException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] argCls = new Class[args.length];
        for (int i = 0; i < argCls.length; ++i) {
            argCls[i] = args[i] == null ? null : args[i].getClass();
        }
        Object result = null;
        try {
            Method method = ReflectUtil.getMethod((Class)daoClass, (String)methodName, (Class[])argCls);
            BaseDao baseDao = this.getDao(daoClass);
            baseDao.setDefaultContext(this.defaultContext);
            if (this.securityContext.getRpcName() != null && this.securityContext.getRpcName().trim().length() > 0) {
                baseDao.setRpcName(this.securityContext.getRpcName());
            }
            if (this.rpcName != null && this.rpcName.trim().length() > 0) {
                baseDao.setRpcName(this.rpcName);
            }
            if (this.logEvent) {
                try {
                    this.logCall(methodName);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not log the call: " + methodName), (Throwable)e);
                }
            }
            result = method.invoke((Object)baseDao, args);
        }
        finally {
            this.setRpcName(null);
        }
        return result;
    }

    protected <T> ServiceResponse<T> singleResult(Class T, Class daoClass, String methodName) {
        Object[] args = new Object[]{};
        return this.singleResult(T, daoClass, methodName, args);
    }

    protected <T> ServiceResponse<T> singleResult(Class T, Class daoClass, String methodName, Object arg) {
        Object[] args = new Object[]{arg};
        return this.singleResult(T, daoClass, methodName, args);
    }

    protected <T> ServiceResponse<T> singleResult(Class T, Class daoClass, String methodName, Object[] args) {
        ServiceResponse response = new ServiceResponse();
        try {
            Object result = this.invokeCall(daoClass, methodName, args);
            response.setPayload(result);
        }
        catch (Exception ex) {
            Throwable cause = ex instanceof InvocationTargetException ? ex.getCause() : ex;
            if (cause instanceof VistaBrokerException) {
                if (cause instanceof VistaBrokerSocketTimeoutException) {
                    String[] properties = new String[]{String.valueOf(((VistaBrokerSocketTimeoutException)cause).getTimeout())};
                    response.addError(((VistaBrokerException)cause).getKey(), properties, null);
                } else {
                    response.addError(((VistaBrokerException)cause).getKey());
                }
            } else {
                response.addError(cause.getMessage());
            }
            log.error((Object)"VistaBrokerException", cause);
        }
        return response;
    }

    protected <T> CollectionServiceResponse<T> collectionResult(Class T, Class daoClass, String methodName) {
        Object[] args = new Object[]{};
        return this.collectionResult(T, daoClass, methodName, args);
    }

    protected <T> CollectionServiceResponse<T> collectionResult(Class T, Class daoClass, String methodName, Object arg) {
        Object[] args = new Object[]{arg};
        return this.collectionResult(T, daoClass, methodName, args);
    }

    protected <T> CollectionServiceResponse<T> collectionResult(Class T, Class daoClass, String methodName, Object[] args) {
        CollectionServiceResponse response = new CollectionServiceResponse();
        try {
            Collection result = (Collection)this.invokeCall(daoClass, methodName, args);
            response.setCollection(result);
        }
        catch (Exception ex) {
            Throwable cause = ex instanceof InvocationTargetException ? ex.getCause() : ex;
            if (cause instanceof VistaBrokerException) {
                if (cause instanceof VistaBrokerSocketTimeoutException) {
                    String[] properties = new String[]{String.valueOf(((VistaBrokerSocketTimeoutException)cause).getTimeout())};
                    response.addError(((VistaBrokerException)cause).getKey(), properties, null);
                } else {
                    response.addError(((VistaBrokerException)cause).getKey());
                }
            } else {
                response.addError(cause.getMessage());
            }
            log.error((Object)"VistaBrokerException", cause);
        }
        return response;
    }

    protected BaseDao getDao(Class daoClass) throws VistaBrokerException {
        if (this.securityContext == null) {
            throw new VistaBrokerSecurityException("client not authenticated");
        }
        try {
            Class[] argCls = new Class[]{};
            Object[] argObjs = new Object[]{};
            Constructor ct = daoClass.getConstructor(argCls);
            this.baseDao = (BaseDao)ct.newInstance(argObjs);
            this.baseDao.setSecurityContext(this.securityContext);
        }
        catch (Exception e) {
            log.error((Object)"Error instantiating DAO: ", (Throwable)e);
        }
        return this.baseDao;
    }

    protected void logCall(String call) {
    }
}

