/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.QueueHandle;
import gov.va.med.lom.vistabroker.patient.data.TiuNoteHeader;
import gov.va.med.lom.vistabroker.patient.data.TiuNoteHeadersSelection;
import gov.va.med.lom.vistabroker.patient.data.UnsignedNoteHeaders;
import gov.va.med.lom.vistabroker.user.dao.VistaUserDao;
import gov.va.med.lom.vistabroker.user.data.VistaUser;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiuNoteHeadersDao
extends BaseDao {
    public static final String CLASS_PROGRESS_NOTES = "3";
    public static final String CLASS_DISCHARGE_SUMMARIES = "244";
    public static final String CLASS_CLINICAL_PROCEDURES = "1758";
    public static final String CLASS_SURGICAL_REPORTS = "1390";
    public static int SIGNED_DOCUMENTS_ALL = 1;
    public static int UNSIGNED_DOCUMENTS = 2;
    public static int UNCOSIGNED_DOCUMENTS = 3;
    public static int SIGNED_DOCUMENTS_AUTHOR = 4;
    public static int SIGNED_DOCUMENTS_DATE_RANGE = 5;
    public static int UNSIGNED_BY_ADDITIONAL_SIGNER = 91;

    public TiuNoteHeadersDao() {
    }

    public TiuNoteHeadersDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<TiuNoteHeader> getSignedProgressNoteHeaders(String dfn, int limit) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setAuthorDuz(null);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setLimit(limit);
        tiuNoteHeadersSelection.setShowAddenda(true);
        tiuNoteHeadersSelection.setNoteStatus(SIGNED_DOCUMENTS_ALL);
        tiuNoteHeadersSelection.setNoteClass(CLASS_PROGRESS_NOTES);
        return this.getTiuNoteHeaders(dfn, tiuNoteHeadersSelection);
    }

    public List<TiuNoteHeader> getSignedDischargeSummaryHeaders(String dfn, int limit) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setAuthorDuz(null);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setLimit(limit);
        tiuNoteHeadersSelection.setShowAddenda(true);
        tiuNoteHeadersSelection.setNoteStatus(SIGNED_DOCUMENTS_ALL);
        tiuNoteHeadersSelection.setNoteClass(CLASS_DISCHARGE_SUMMARIES);
        return this.getTiuNoteHeaders(dfn, tiuNoteHeadersSelection);
    }

    public List<TiuNoteHeader> getSignedTiuNoteHeaders(String dfn, String noteClass, int limit) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setAuthorDuz(null);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setLimit(limit);
        tiuNoteHeadersSelection.setShowAddenda(true);
        tiuNoteHeadersSelection.setNoteStatus(SIGNED_DOCUMENTS_ALL);
        tiuNoteHeadersSelection.setNoteClass(noteClass);
        return this.getTiuNoteHeaders(dfn, tiuNoteHeadersSelection);
    }

    public List<TiuNoteHeader> getUnsignedTiuNoteHeadersByAuthor(String dfn, String duz, int limit) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setAuthorDuz(duz);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setLimit(limit);
        tiuNoteHeadersSelection.setShowAddenda(true);
        tiuNoteHeadersSelection.setNoteStatus(UNSIGNED_DOCUMENTS);
        tiuNoteHeadersSelection.setNoteClass(null);
        return this.getTiuNoteHeaders(dfn, tiuNoteHeadersSelection);
    }

    public List<TiuNoteHeader> getUncosignedTiuNoteHeadersByAuthor(String dfn, String duz, int limit) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setAuthorDuz(duz);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setLimit(limit);
        tiuNoteHeadersSelection.setShowAddenda(true);
        tiuNoteHeadersSelection.setNoteStatus(UNCOSIGNED_DOCUMENTS);
        tiuNoteHeadersSelection.setNoteClass(null);
        return this.getTiuNoteHeaders(dfn, tiuNoteHeadersSelection);
    }

    public List<TiuNoteHeader> getAllUnsignedTiuNoteHeaders(String dfn, String duz, int limit) throws Exception {
        List<TiuNoteHeader> list1 = this.getUnsignedTiuNoteHeadersByAuthor(dfn, duz, limit);
        List<TiuNoteHeader> list2 = this.getUncosignedTiuNoteHeadersByAuthor(dfn, duz, limit);
        list1.addAll(list2);
        return list1;
    }

    public List<TiuNoteHeader> getAllTiuNoteHeaders(String dfn, String duz, int limit) throws Exception {
        List<TiuNoteHeader> list1 = this.getUnsignedTiuNoteHeadersByAuthor(dfn, duz, limit);
        List<TiuNoteHeader> list2 = this.getUncosignedTiuNoteHeadersByAuthor(dfn, duz, limit);
        List<TiuNoteHeader> list3 = this.getSignedProgressNoteHeaders(dfn, limit);
        List<TiuNoteHeader> list4 = this.getSignedDischargeSummaryHeaders(dfn, limit);
        list1.addAll(list2);
        list1.addAll(list3);
        list1.addAll(list4);
        return list1;
    }

    public UnsignedNoteHeaders getUnsignedNoteHeaders(String authorDuz, int limit, boolean unsignedNotes, boolean uncosignedNotes) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setLimit(limit);
        tiuNoteHeadersSelection.setShowAddenda(true);
        UnsignedNoteHeaders unsignedNoteHeaders = new UnsignedNoteHeaders();
        List<TiuNoteHeader> list = null;
        if (unsignedNotes) {
            tiuNoteHeadersSelection.setAuthorDuz(authorDuz);
            tiuNoteHeadersSelection.setNoteStatus(UNSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_PROGRESS_NOTES);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUnsignedProgressNotes(list);
            tiuNoteHeadersSelection.setNoteStatus(UNSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_DISCHARGE_SUMMARIES);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUnsignedDischargeSummaries(list);
            tiuNoteHeadersSelection.setNoteStatus(UNSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_CLINICAL_PROCEDURES);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUnsignedClinicalProcedures(list);
            tiuNoteHeadersSelection.setNoteStatus(UNSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_SURGICAL_REPORTS);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUnsignedSurgicalReports(list);
            tiuNoteHeadersSelection.setNoteStatus(UNSIGNED_BY_ADDITIONAL_SIGNER);
            tiuNoteHeadersSelection.setNoteClass(null);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUnsignedByExpectedAdditonalSignerNotes(list);
        }
        if (uncosignedNotes) {
            tiuNoteHeadersSelection.setAuthorDuz(authorDuz);
            tiuNoteHeadersSelection.setNoteStatus(UNCOSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_PROGRESS_NOTES);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUncosignedProgressNotes(list);
            tiuNoteHeadersSelection.setNoteStatus(UNCOSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_DISCHARGE_SUMMARIES);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUncosignedDischargeSummaries(list);
            tiuNoteHeadersSelection.setNoteStatus(UNCOSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_CLINICAL_PROCEDURES);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUncosignedClinicalProcedures(list);
            tiuNoteHeadersSelection.setNoteStatus(UNCOSIGNED_DOCUMENTS);
            tiuNoteHeadersSelection.setNoteClass(CLASS_SURGICAL_REPORTS);
            list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
            unsignedNoteHeaders.setUncosignedSurgicalReports(list);
        }
        return unsignedNoteHeaders;
    }

    public UnsignedNoteHeaders getAllUnsignedNoteHeaders(String authorDuz) throws Exception {
        TiuNoteHeadersSelection tiuNoteHeadersSelection = new TiuNoteHeadersSelection();
        tiuNoteHeadersSelection.setAscending(false);
        tiuNoteHeadersSelection.setBeginDate(null);
        tiuNoteHeadersSelection.setEndDate(null);
        tiuNoteHeadersSelection.setShowAddenda(true);
        UnsignedNoteHeaders unsignedNoteHeaders = new UnsignedNoteHeaders();
        List<TiuNoteHeader> list = null;
        tiuNoteHeadersSelection.setAuthorDuz(authorDuz);
        list = this.getTiuNoteHeaders(null, tiuNoteHeadersSelection);
        unsignedNoteHeaders.setUnsignedProgressNotes(list);
        return unsignedNoteHeaders;
    }

    public List<TiuNoteHeader> getTiuNoteHeaders(String dfn, TiuNoteHeadersSelection tiuNoteHeadersSelection) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        if (dfn != null && dfn.length() > 0) {
            this.setDefaultRpcName("TIU DOCUMENTS BY CONTEXT");
        } else {
            this.setDefaultRpcName("ALS TIU CONTEXT");
        }
        this.setTimeoutForCall(60000);
        ArrayList<TiuNoteHeader> tiuNoteHeadersList = new ArrayList();
        String fmDate1 = null;
        if (tiuNoteHeadersSelection.getBeginDate() != null) {
            Long d = Math.round(FMDateUtils.dateToFMDate(tiuNoteHeadersSelection.getBeginDate()));
            fmDate1 = String.valueOf(d);
        } else {
            fmDate1 = "";
        }
        String fmDate2 = null;
        if (tiuNoteHeadersSelection.getEndDate() != null) {
            Long d = Math.round(FMDateUtils.dateToFMDate(tiuNoteHeadersSelection.getEndDate()));
            fmDate2 = String.valueOf(d);
        } else {
            fmDate2 = "";
        }
        Object[] params = new Object[]{String.valueOf(tiuNoteHeadersSelection.getNoteClass()), String.valueOf(tiuNoteHeadersSelection.getNoteStatus()), String.valueOf(dfn), String.valueOf(fmDate1), String.valueOf(fmDate2), String.valueOf(tiuNoteHeadersSelection.getAuthorDuz()), String.valueOf(tiuNoteHeadersSelection.getLimit()), StringUtils.boolToStr((boolean)tiuNoteHeadersSelection.getAscending(), (String)"A", (String)"D"), StringUtils.boolToStr((boolean)tiuNoteHeadersSelection.getShowAddenda(), (String)"1", (String)"0")};
        List<String> list = this.lCall(params);
        tiuNoteHeadersList = this.doGetTiuNoteHeadersList(list, tiuNoteHeadersSelection.getNoteClass(), tiuNoteHeadersSelection.getLimit());
        return tiuNoteHeadersList;
    }

    public QueueHandle getUnsignedByServiceQueueHandle(String service) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ALS QUEUE UNSIGNED-BY-SERVICE");
        Object[] params = new String[]{service};
        String x = this.sCall(params);
        QueueHandle queueHandle = new QueueHandle();
        queueHandle.setHandle(StringUtils.piece((String)x, (int)1));
        queueHandle.setTaskNo(Integer.valueOf(StringUtils.piece((String)x, (int)2)));
        return queueHandle;
    }

    public List<TiuNoteHeader> getUnsignedByServiceReport(String handle, boolean delete) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ALS REPORT UNSIGNED-BY-SERVICE");
        String delFlag = null;
        delFlag = delete ? "1" : "0";
        Object[] params = new String[]{handle, delFlag};
        List<String> list = this.lCall(params);
        if (list.size() > 1) {
            return this.doGetTiuNoteHeadersList(list, null, 0);
        }
        return null;
    }

    public boolean deleteUnsignedByServiceReport(String handle) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ALS DELETE UNSIGNED-BY-SERVICE");
        String x = this.sCall(handle);
        return x.equals("1");
    }

    private List<TiuNoteHeader> doGetTiuNoteHeadersList(List<String> list, String noteClassIen, int limit) {
        ArrayList<TiuNoteHeader> tiuNoteHeaders = new ArrayList<TiuNoteHeader>();
        int num = list.size();
        if (limit > 0 && num > limit) {
            num = limit + 1;
        }
        for (int i = 0; i < num; ++i) {
            GregorianCalendar gc;
            String x = list.get(i);
            if (x.trim().length() <= 0 || StringUtils.piece((String)x, (int)1).length() <= 0) continue;
            String ien = StringUtils.piece((String)x, (int)1);
            String title = StringUtils.piece((String)x, (int)2);
            String refDate = null;
            try {
                refDate = FMDateUtils.fmDateTimeToEnglishDateTime(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)3), (double)0.0));
            }
            catch (ParseException pe) {
                refDate = "";
            }
            String temp = StringUtils.piece((String)x, (int)4);
            String patientName = StringUtils.piece((String)temp, (char)'~', (int)1);
            String dfn = StringUtils.piece((String)temp, (char)'~', (int)2);
            temp = StringUtils.piece((String)x, (int)5);
            String authorDuz = StringUtils.piece((String)temp, (char)';', (int)1);
            String author = StringUtils.piece((String)temp, (char)';', (int)2);
            String hospitalLocation = StringUtils.piece((String)x, (int)6);
            String signatureStatus = StringUtils.piece((String)x, (int)7);
            String visitDateTime = StringUtils.piece((String)x, (int)8);
            String dischargeDateTime = StringUtils.piece((String)x, (int)9);
            String requestIen = StringUtils.piece((String)x, (int)10);
            int numAssociatedImages = StringUtils.toInt((String)StringUtils.piece((String)x, (int)11), (int)0);
            String subject = StringUtils.piece((String)x, (int)12);
            boolean hasChildren = StringUtils.strToBool((String)StringUtils.piece((String)x, (int)13), (String[])new String[]{"+"});
            String parentIen = StringUtils.piece((String)x, (int)14);
            String expectedSignerDuz = StringUtils.piece((String)x, (int)16);
            TiuNoteHeader tiuNoteHeader = new TiuNoteHeader();
            String duz = this.getUserId();
            if (duz == null) {
                VistaUserDao vistaUserDao = new VistaUserDao(this);
                try {
                    VistaUser vistaUser = vistaUserDao.getVistaUser();
                    duz = vistaUser.getDuz();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            tiuNoteHeader.setDuz(duz);
            tiuNoteHeader.setDfn(dfn);
            tiuNoteHeader.setIen(ien);
            tiuNoteHeader.setTitle(title);
            tiuNoteHeader.setReferenceDatetimeStr(refDate);
            try {
                tiuNoteHeader.setReferenceDatetime(DateUtils.toDate((String)refDate, (String)DateUtils.ENGLISH_SHORT_DATE_TIME_FORMAT2));
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
            tiuNoteHeader.setPatientName(patientName);
            tiuNoteHeader.setAuthorDuz(authorDuz);
            tiuNoteHeader.setAuthorName(author);
            tiuNoteHeader.setHospitalLocation(hospitalLocation);
            tiuNoteHeader.setSignatureStatus(signatureStatus);
            tiuNoteHeader.setVisitDatetimeStr(visitDateTime);
            try {
                gc = DateUtils.fmDateTimeToDateTime((double)Double.valueOf(StringUtils.piece((String)visitDateTime, (char)';', (int)2)));
                tiuNoteHeader.setVisitDatetime(gc.getTime());
            }
            catch (Exception pe) {
                // empty catch block
            }
            tiuNoteHeader.setDischargeDatetimeStr(dischargeDateTime);
            try {
                gc = DateUtils.fmDateTimeToDateTime((double)Double.valueOf(StringUtils.piece((String)dischargeDateTime, (char)';', (int)2)));
                tiuNoteHeader.setDischargeDatetime(gc.getTime());
            }
            catch (Exception pe) {
                // empty catch block
            }
            tiuNoteHeader.setRequestIen(requestIen);
            tiuNoteHeader.setNumAssociatedImages(numAssociatedImages);
            tiuNoteHeader.setSubject(subject);
            tiuNoteHeader.setHasChildren(hasChildren);
            tiuNoteHeader.setParentIen(parentIen);
            tiuNoteHeader.setExpectedSignerDuz(expectedSignerDuz);
            tiuNoteHeader.setDocumentClassIen(noteClassIen);
            if (tiuNoteHeader.getDocumentClassIen() == null) {
                tiuNoteHeader.setDocumentClass("");
            } else if (tiuNoteHeader.getDocumentClassIen().equals(CLASS_PROGRESS_NOTES)) {
                tiuNoteHeader.setDocumentClass("Progress Note");
            } else if (tiuNoteHeader.getDocumentClassIen().equals(CLASS_DISCHARGE_SUMMARIES)) {
                tiuNoteHeader.setDocumentClass("Discharge Summary");
            } else if (tiuNoteHeader.getDocumentClassIen().equals(CLASS_CLINICAL_PROCEDURES)) {
                tiuNoteHeader.setDocumentClass("Clinical Procedure");
            } else if (tiuNoteHeader.getDocumentClassIen().equals(CLASS_SURGICAL_REPORTS)) {
                tiuNoteHeader.setDocumentClass("Surgical Report");
            }
            tiuNoteHeaders.add(tiuNoteHeader);
        }
        return tiuNoteHeaders;
    }
}

