/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.LockDocumentResult;
import gov.va.med.lom.vistabroker.patient.data.TiuNote;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiuNoteDao
extends BaseDao {
    public TiuNoteDao() {
    }

    public TiuNoteDao(BaseDao baseDao) {
        super(baseDao);
    }

    public TiuNote getTiuNote(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU GET RECORD TEXT");
        TiuNote tiuNote = new TiuNote();
        String text = this.sCall(ien);
        tiuNote.setIen(ien);
        tiuNote.setText(text);
        return tiuNote;
    }

    public TiuNote getTiuNoteForEdit(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU LOAD RECORD FOR EDIT");
        TiuNote tiuNote = new TiuNote();
        Object[] params = new String[]{String.valueOf(ien), ".01;.06;.07;1301;1204;1208;1701;1205;1405;2101;70201;70202"};
        StringBuffer text = new StringBuffer(this.sCall(params));
        int index = text.indexOf("$TXT");
        if (index < 0) {
            tiuNote.setIen(null);
            tiuNote.setMessage(text.delete(text.indexOf("~"), 2).toString());
        } else {
            text.delete(0, index + 4);
            tiuNote.setIen(ien);
            tiuNote.setText(text.toString().trim());
        }
        return tiuNote;
    }

    public String getTiuListItem(String docIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWTIU GET LISTBOX ITEM");
        String x = this.sCall(docIen);
        return x;
    }

    public boolean isSurgeryTitle(String titleIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU IS THIS A SURGERY");
        String x = this.sCall(titleIen);
        return x.equals("1");
    }

    public boolean isConsultTitle(String titleIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU IS THIS A CONSULT");
        String x = this.sCall(titleIen);
        return x.equals("1");
    }

    public boolean authorHasSigned(String titleIen, String userDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU HAS AUTHOR SIGNED?");
        Object[] params = new Object[]{titleIen, userDuz};
        String x = this.sCall(params);
        return x.equals("1");
    }

    public String getTitleIenForNote(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU GET DOCUMENT TITLE");
        return this.sCall(ien);
    }

    public String getPackageRefForNote(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU GET REQUEST");
        return this.sCall(ien);
    }

    public String getConsultIenforNote(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU GET REQUEST");
        String x = this.sCall(ien);
        if (StringUtils.piece((String)x, (char)';', (int)2) != "GMR(123,") {
            return "-1";
        }
        return StringUtils.piece((String)x, (char)';', (int)1);
    }

    public String getVisitStrForNote(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE NOTEVSTR");
        return this.sCall(ien);
    }

    public List<String> getPCEDataForNote(String ien, String patientDfn, String visitStr) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE PCE4NOTE");
        if (ien != null) {
            return this.lCall(ien);
        }
        Object[] params = new Object[]{"", patientDfn, visitStr};
        return this.lCall(params);
    }

    public String getTiuDetails(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU DETAILED DISPLAY");
        return this.sCall(ien);
    }

    public LockDocumentResult lockDocument(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU LOCK RECORD");
        LockDocumentResult lockDocumentResult = new LockDocumentResult();
        String x = this.sCall(ien);
        if (x.charAt(0) == '0') {
            lockDocumentResult.setSuccess(true);
            lockDocumentResult.setMessage("");
        } else {
            lockDocumentResult.setSuccess(false);
            lockDocumentResult.setMessage(StringUtils.piece((String)x, (int)2));
        }
        return lockDocumentResult;
    }

    public void unlockDocument(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU UNLOCK RECORD");
        this.sCall(ien);
    }

    public boolean deleteDocument(String ien, String reason) throws Exception {
        Object[] params = new String[]{String.valueOf(ien), reason};
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU DELETE RECORD");
        String x = this.sCall(params);
        return StringUtils.piece((String)x, (int)1).equals("0");
    }

    public boolean justifyDocumentDelete(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU JUSTIFY DELETE?");
        String x = this.sCall(ien);
        return x.equals("1");
    }
}

