/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.Patient;
import gov.va.med.lom.vistabroker.patient.data.SimilarRecordsStatus;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatientSelectionDao
extends BaseDao {
    public PatientSelectionDao() {
    }

    public PatientSelectionDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Patient> listAllPatients() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT LIST ALL");
        Object[] params = new String[]{"", "1"};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, true);
    }

    public List<Patient> getSubSetOfPatients(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT LIST ALL");
        Object[] params = new String[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, true);
    }

    public List<Patient> listPtByProvider(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT PROVIDER PATIENTS");
        List<String> list = this.lCall(ien);
        return this.getItems(list, false, true);
    }

    public List<Patient> listPtBySpecialty(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT SPECIALTY PATIENTS");
        List<String> list = this.lCall(ien);
        return this.getItems(list, false, true);
    }

    public List<Patient> listPtByTeam(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT TEAM PATIENTS");
        List<String> list = this.lCall(ien);
        return this.getItems(list, false, true);
    }

    public List<Patient> listPtByClinic(String ien, Date firstDate, Date lastDate) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT CLINIC PATIENTS");
        double date1 = FMDateUtils.dateToFMDate(firstDate);
        double date2 = FMDateUtils.dateToFMDate(lastDate);
        Object[] params = new String[]{String.valueOf(ien), String.valueOf(date1), String.valueOf(date2)};
        List<String> list = this.lCall(params);
        ArrayList<Patient> patients = new ArrayList<Patient>();
        for (String s : list) {
            if (s.length() <= 0 || StringUtils.piece((String)s, (int)1).length() <= 0) continue;
            Patient patient = new Patient();
            patient.setDfn(StringUtils.piece((String)s, (int)1));
            patient.setName(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)));
            patient.setLocation(StringUtils.piece((String)s, (int)3));
            patient.setDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)4)));
            try {
                patient.setDateStr(DateUtils.toEnglishDate((Date)patient.getDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            patients.add(patient);
        }
        return patients;
    }

    public List<Patient> listPtByWard(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT BYWARD");
        List<String> list = this.lCall(ien);
        ArrayList<Patient> patients = new ArrayList<Patient>();
        for (String s : list) {
            if (s.length() <= 0 || StringUtils.piece((String)s, (int)1).length() <= 0) continue;
            Patient patient = new Patient();
            patient.setDfn(StringUtils.piece((String)s, (int)1));
            patient.setName(StringUtils.piece((String)s, (int)2));
            patient.setLocation(StringUtils.piece((String)s, (int)3));
            patients.add(patient);
        }
        return patients;
    }

    public List<Patient> listPtByLast5(String last5) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT LAST5");
        Object[] params = new String[]{String.valueOf(last5.toUpperCase())};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, false);
    }

    public List<Patient> listPtByRPLLast5(String last5) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT LAST5 RPL");
        Object[] params = new String[]{String.valueOf(last5.toUpperCase())};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, false);
    }

    public List<Patient> listPtByFullSSN(String ssn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT FULLSSN");
        ssn = StringUtils.unformatSSN((String)ssn);
        Object[] params = new String[]{String.valueOf(ssn.toUpperCase())};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, false);
    }

    public List<Patient> listPtByRPLFullSSN(String ssn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT FULLSSN RPL");
        ssn = StringUtils.unformatSSN((String)ssn);
        Object[] params = new String[]{String.valueOf(ssn.toUpperCase())};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, false);
    }

    public List<Patient> readRPLPtList(String rplJobNumber, String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT READ RPL");
        Object[] params = new String[]{rplJobNumber, startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getItems(list, false, true);
    }

    public List<Patient> listPtByDflt() throws Exception {
        String sort = this.getDfltSort();
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT DEFAULT PATIENT LIST");
        List list = this.lCall();
        char s = this.getDfltPtListSrc();
        if (s == 'C') {
            list = sort.equals("P") ? StringUtils.sortByPiece(list, (int)4) : StringUtils.sortByPiece(list, (int)2);
        } else {
            int sourceType = 0;
            if (sort.equals("M")) {
                sourceType = 1;
            } else if (sort.equals("W")) {
                sourceType = 2;
            }
            switch (sourceType) {
                case 1: {
                    if (sort.equals("S")) {
                        list = StringUtils.sortByPieces((List)list, (int[])new int[]{3, 8, 2});
                        break;
                    }
                    if (sort.equals("P")) {
                        list = StringUtils.sortByPieces((List)list, (int[])new int[]{8, 2});
                        break;
                    }
                    if (sort.equals("T")) {
                        list = StringUtils.sortByPiece((List)list, (int)5);
                        break;
                    }
                    list = StringUtils.sortByPiece((List)list, (int)2);
                    break;
                }
                case 2: {
                    list = sort.equals("R") ? StringUtils.sortByPieces((List)list, (int[])new int[]{3, 2}) : StringUtils.sortByPiece((List)list, (int)2);
                }
            }
        }
        list = StringUtils.mixedCaseList((List)list);
        ArrayList<Patient> patients = new ArrayList<Patient>();
        for (String x : list) {
            if (x.length() <= 0 || StringUtils.piece((String)x, (int)1).length() <= 0) continue;
            Patient patient = new Patient();
            patient.setDfn(StringUtils.piece((String)x, (int)1));
            patient.setName(StringUtils.piece((String)x, (int)2));
            patient.setDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)x, (int)3)));
            try {
                patient.setDateStr(DateUtils.toEnglishDate((Date)patient.getDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            patient.setLocation(StringUtils.piece((String)x, (int)4));
            patients.add(patient);
        }
        return patients;
    }

    public Patient listPtTop() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT TOP");
        Patient patient = null;
        String x = StringUtils.mixedCase((String)this.sCall());
        if (x.length() > 0 && StringUtils.piece((String)x, (int)1).length() > 0) {
            patient = new Patient();
            patient.setDfn(StringUtils.piece((String)x, (int)1));
            patient.setName(StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)2)));
        }
        return patient;
    }

    public String getDfltPtList() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT DEFAULT LIST SOURCE");
        return this.sCall();
    }

    public char getDfltPtListSrc() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT DFLTSRC");
        String x = this.sCall();
        String s = StringUtils.piece((String)x, (int)2);
        if (s.length() > 0) {
            return s.charAt(1);
        }
        return '\u0000';
    }

    public void savePtListDflt(String x) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT SAVDFLT");
        this.sCall(x);
    }

    public String getDfltSort() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT DEFAULT LIST SORT");
        String x = this.sCall();
        if (x.length() == 0) {
            x = "A";
        }
        return x;
    }

    public String makeRPLPtList(String rplList) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT MAKE ALL");
        return this.sCall(rplList);
    }

    public void killRPLPtList(String rplJobNumber) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT KILL RPL");
        Object[] params = new String[]{rplJobNumber};
        this.sCall(params);
    }

    public SimilarRecordsStatus getSimilarRecordsFound(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("DG CHK BS5 XREF Y/N");
        List<String> list = this.lCall(dfn);
        SimilarRecordsStatus similarRecordsStatus = new SimilarRecordsStatus();
        String x = list.get(0);
        similarRecordsStatus.setExists(x.equals("1"));
        list.remove(0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(0) + '\n');
        }
        similarRecordsStatus.setMessage(sb.toString());
        return similarRecordsStatus;
    }

    public List<String> listDateRangeClinic() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT CLINRNG");
        return this.lCall();
    }

    public String defaultDateRangeClinic() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT DEFAULT CLINIC DATE RANG");
        return this.sCall();
    }

    public String getAlsiDfnLookup(String ssn) throws Exception {
        this.setDefaultContext(null);
        this.setDefaultRpcName("ALSI DFN LOOKUP");
        return this.sCall(ssn);
    }

    private List<Patient> getItems(List<String> list, boolean mixedCase, boolean checkAlias) {
        ArrayList<Patient> patientList = new ArrayList<Patient>();
        for (String s : list) {
            if (s.length() <= 0 || StringUtils.piece((String)s, (int)1).length() <= 0) continue;
            Patient patient = new Patient();
            String dfn = StringUtils.piece((String)s, (int)1);
            String name = mixedCase ? StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)) : StringUtils.piece((String)s, (int)2);
            patient.setName(name);
            if (checkAlias) {
                String nonAliasedName = mixedCase ? StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)6)) : StringUtils.piece((String)s, (int)6);
                if (name.compareTo(nonAliasedName) != 0) {
                    name = name + "-- ALIAS ";
                    patient.setAlias(true);
                } else {
                    patient.setAlias(false);
                }
                patient.setNonAliasedName(nonAliasedName);
            } else {
                patient.setNonAliasedName(name);
            }
            if (StringUtils.piece((String)s, (int)3).length() == 0) {
                patient.setDfn(dfn);
            } else {
                Date date = FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)3));
                String ssn = StringUtils.piece((String)s, (int)4);
                patient.setDfn(dfn);
                patient.setDate(date);
                try {
                    patient.setDateStr(DateUtils.toEnglishDate((Date)patient.getDate()));
                }
                catch (ParseException pe) {
                    // empty catch block
                }
                patient.setSsn(ssn);
            }
            patientList.add(patient);
        }
        return patientList;
    }
}

