/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.MeansTestStatus;
import gov.va.med.lom.vistabroker.patient.data.PatientInfo;
import gov.va.med.lom.vistabroker.patient.data.PatientLocation;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class PatientInfoDao
extends BaseDao {
    private PatientInfo patientInfo;

    public PatientInfoDao() {
    }

    public PatientInfoDao(BaseDao baseDao) {
        super(baseDao);
    }

    public PatientLocation getCurrentPatientLocation(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT INPLOC");
        String x = this.sCall(dfn);
        PatientLocation patientLocation = new PatientLocation();
        if (x.length() > 0) {
            patientLocation.setIen(StringUtils.piece((String)x, (int)1));
            patientLocation.setName(StringUtils.piece((String)x, (int)2));
            patientLocation.setService(StringUtils.piece((String)x, (int)3));
        }
        return patientLocation;
    }

    public MeansTestStatus getMeansTestRequired(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("DG CHK PAT/DIV MEANS TEST");
        List<String> list = this.lCall(dfn);
        MeansTestStatus meansTestStatus = new MeansTestStatus();
        String x = list.get(0);
        meansTestStatus.setRequired(x.equals("1"));
        list.remove(0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(0) + '\n');
        }
        meansTestStatus.setMessage(sb.toString().trim());
        return meansTestStatus;
    }

    public PatientInfo getPatientInfo(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT ID INFO");
        this.patientInfo = new PatientInfo();
        String x = this.sCall(dfn);
        if (!StringUtils.piece((String)x, (int)1).equals("-1")) {
            GregorianCalendar gc;
            this.patientInfo.setDfn(dfn);
            this.patientInfo.setName(StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)8)));
            this.patientInfo.setSsn(StringUtils.formatSSN((String)StringUtils.piece((String)x, (int)1)));
            this.patientInfo.setSex(StringUtils.piece((String)x, (int)3));
            String dob = StringUtils.piece((String)x, (int)2);
            if (dob.length() > 0) {
                this.patientInfo.setDob(FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)dob, (double)0.0)));
                try {
                    this.patientInfo.setDobStr(DateUtils.toEnglishDate((Date)this.patientInfo.getDob()));
                }
                catch (ParseException pe) {}
            } else {
                gc = new GregorianCalendar();
                gc.set(1, 0);
                gc.set(2, 0);
                gc.set(5, 0);
                this.patientInfo.setDob(gc.getTime());
                this.patientInfo.setDobStr("");
            }
            this.patientInfo.setAge(DateUtils.calcAge((Date)this.patientInfo.getDob()));
            this.patientInfo.setVeteran(StringUtils.strToBool((String)StringUtils.piece((String)x, (int)4), (String)"Y"));
            this.patientInfo.setScPct(StringUtils.toInt((String)StringUtils.piece((String)x, (int)5), (int)0));
            this.patientInfo.setLocation(StringUtils.piece((String)x, (int)6));
            this.patientInfo.setRoomBed(StringUtils.piece((String)x, (int)7));
            this.patientInfo.setInpatient(this.patientInfo.getLocation().length() > 0);
            this.setDefaultRpcName("ORWPT DIEDON");
            x = this.sCall(dfn);
            if (x.length() > 0) {
                this.patientInfo.setDeceasedDate(FMDateUtils.fmDateTimeToDate(Double.valueOf(x)));
                try {
                    this.patientInfo.setDeceasedDateStr(DateUtils.toEnglishDate((Date)this.patientInfo.getDeceasedDate()));
                }
                catch (ParseException pe) {}
            } else {
                gc = new GregorianCalendar();
                gc.set(1, 0);
                gc.set(2, 0);
                gc.set(5, 0);
                this.patientInfo.setDeceasedDate(gc.getTime());
                this.patientInfo.setDeceasedDateStr("");
            }
        }
        return this.patientInfo;
    }
}

