/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.Medication;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedicationsDao
extends BaseDao {
    public MedicationsDao() {
    }

    public MedicationsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Medication> getMedications(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPS ACTIVE");
        List<String> list = this.lCall(dfn);
        ArrayList<Medication> medications = new ArrayList<Medication>();
        int i = 0;
        String x = null;
        while (i < list.size()) {
            x = list.get(i);
            if (x.length() > 0 && x.charAt(0) == '~') {
                String type = StringUtils.piece((String)x, (int)1).substring(1);
                String pharmId = StringUtils.piece((String)x, (int)2);
                String name = StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)3));
                String infRate = StringUtils.piece((String)x, (int)4);
                String totDose = StringUtils.piece((String)x, (int)7);
                String unitDose = StringUtils.piece((String)x, (int)8);
                String status = StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)10));
                int refills = StringUtils.toInt((String)StringUtils.piece((String)x, (int)6), (int)0);
                String orderId = StringUtils.piece((String)x, (int)9);
                String expires = null;
                Date expiresDate = null;
                String lastFilled = null;
                Date lastFilledDate = null;
                try {
                    expiresDate = FMDateUtils.fmDateTimeToDate(StringUtils.toInt((String)StringUtils.piece((String)x, (int)5), (int)0));
                    expires = DateUtils.toEnglishDate((Date)expiresDate);
                }
                catch (ParseException pe) {
                    // empty catch block
                }
                try {
                    lastFilledDate = FMDateUtils.fmDateTimeToDate(StringUtils.toInt((String)StringUtils.piece((String)x, (int)11), (int)0));
                    lastFilled = DateUtils.toEnglishDate((Date)lastFilledDate);
                }
                catch (ParseException pe) {
                    // empty catch block
                }
                StringBuffer sb = new StringBuffer();
                x = list.get(++i);
                boolean isSig = false;
                while (i < list.size() && x.length() > 0 && x.charAt(0) != '~') {
                    boolean bl = isSig = isSig || x.charAt(0) == '\\';
                    if (isSig) {
                        sb.append(x.substring(1, x.length()));
                        sb.append(" ");
                    }
                    if (++i >= list.size()) continue;
                    x = list.get(i);
                }
                String sig = sb.toString();
                Medication medication = new Medication();
                medication.setDfn(dfn);
                medication.setType(type);
                medication.setName(name);
                medication.setStatus(status);
                medication.setRefills(refills);
                medication.setPharmId(pharmId);
                medication.setOrderId(orderId);
                medication.setTotalDose(totDose);
                medication.setUnitDose(unitDose);
                medication.setInfRate(infRate);
                medication.setSig(sig);
                medication.setDateExpires(expiresDate);
                medication.setDateLastFilled(lastFilledDate);
                medication.setDateExpiresStr(expires);
                medication.setDateLastFilledStr(lastFilled);
                medications.add(medication);
                continue;
            }
            ++i;
        }
        return medications;
    }

    public List<Medication> getCoverSheetMeds(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPS COVER");
        List<String> list = this.lCall(dfn);
        ArrayList<Medication> medications = new ArrayList<Medication>();
        for (String s : list) {
            if (s.length() <= 0) continue;
            String pharmId = StringUtils.piece((String)s, (int)1);
            String name = StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2));
            String orderId = StringUtils.piece((String)s, (int)3);
            String status = StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)4));
            Medication medication = new Medication();
            medication.setName(name);
            medication.setStatus(status);
            medication.setPharmId(pharmId);
            medication.setOrderId(orderId);
            medications.add(medication);
        }
        return medications;
    }

    public String getMedDetails(String dfn, String id) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPS DETAIL");
        Object[] params = new Object[]{dfn, id.toUpperCase()};
        List<String> list = this.lCall(params);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s + "\n");
        }
        return sb.toString().trim();
    }

    public String getMedAdminHistory(String dfn, String id) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPS MEDHIST");
        Object[] params = new Object[]{dfn, id.toUpperCase()};
        List<String> list = this.lCall(params);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s + "\n");
        }
        return sb.toString().trim();
    }
}

