/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.DiscreteItemData;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteResultsDao
extends BaseDao {
    public static final String LAB_TESTS_FILENUM = "63";
    public static final String VITALS_FILENUM = "120.5";
    public static final String PROBLEMS_FILENUM = "9000011";
    public static final String ANATOMIC_PATHOLOGY_FILENUM = "63AP";
    public static final String MICROBIOLOGY_FILENUM = "63MI";
    public static final String BLOOD_BANK_FILENUM = "63BB";
    public static final String MEDICINE_FILENUM = "690";
    private HashMap<String, List<String>> itemCache = new HashMap();

    public DiscreteResultsDao() {
    }

    public DiscreteResultsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public String lookupItemNum(String dfn, String fileNum, String itemName) throws Exception {
        String key = dfn + '^' + fileNum;
        List<String> itemList = null;
        if (!this.itemCache.containsKey(key)) {
            this.setDefaultContext("OR CPRS GUI CHART");
            this.setDefaultRpcName("ORWGRPC ITEMS");
            Object[] params = new Object[]{dfn, fileNum};
            List<String> list = this.lCall(params);
            this.itemCache.put(key, list);
        }
        itemList = this.itemCache.get(key);
        String itemNum = null;
        for (String s : itemList) {
            if (!StringUtils.piece((String)s, (int)4).equals(itemName)) continue;
            itemNum = StringUtils.piece((String)s, (int)2);
            break;
        }
        return itemNum;
    }

    public List<DiscreteItemData> getItemDataSet(String dfn, String typeNum, String itemNum, double fmStartDate) throws Exception {
        List<String> list = this.getRawItemData(dfn, typeNum, itemNum);
        ArrayList<DiscreteItemData> resultItemData = new ArrayList<DiscreteItemData>();
        double fmDate = 0.0;
        for (String s : list) {
            fmDate = Double.valueOf(StringUtils.piece((String)s, (int)3));
            if (!(fmDate >= fmStartDate)) continue;
            DiscreteItemData data = this.parseRawItemDataLine(s);
            resultItemData.add(data);
        }
        return resultItemData;
    }

    public DiscreteItemData getLatestItemDataPoint(String dfn, String typeNum, String itemNum) {
        List<String> list = this.getRawItemData(dfn, typeNum, itemNum);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        String lastLine = list.get(size - 1);
        DiscreteItemData datapoint = this.parseRawItemDataLine(lastLine);
        return datapoint;
    }

    private DiscreteItemData parseRawItemDataLine(String line) {
        double fmDate = Double.valueOf(StringUtils.piece((String)line, (int)3));
        DiscreteItemData data = new DiscreteItemData();
        data.setFileNum(StringUtils.piece((String)line, (int)1));
        data.setItemNum(StringUtils.piece((String)line, (int)2));
        data.setFmDate(fmDate);
        data.setValue(StringUtils.piece((String)line, (int)5));
        data.setAlert(StringUtils.piece((String)line, (int)6));
        if (data.getFileNum().equals(LAB_TESTS_FILENUM)) {
            data.setSampleType(StringUtils.piece((String)line, (int)8));
            data.setReferenceRange(StringUtils.piece((String)line, (int)9));
        }
        return data;
    }

    private List<String> getRawItemData(String dfn, String typeNum, String itemNum) {
        GregorianCalendar now = new GregorianCalendar();
        double fmEndDate = FMDateUtils.dateTimeToFMDateTime(now);
        ArrayList<String> result = new ArrayList();
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWGRPC ITEMDATA");
        String typeItem = typeNum + '^' + itemNum;
        Object[] params = new Object[]{typeItem, fmEndDate, dfn};
        try {
            result = this.lCall(params);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }
}

