/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.dao.SpecialtiesTeamsDao;
import gov.va.med.lom.vistabroker.patient.data.Demographics;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DemographicsDao
extends BaseDao {
    private static final Log log = LogFactory.getLog(DemographicsDao.class);
    public static final String SEX_MALE = "Male";
    public static final String SEX_FEMALE = "Female";
    public static final String SEX_UNKNOWN = "Unknown";
    private static Map<String, Map<String, String>> specialtiesMap;

    public DemographicsDao() {
    }

    public DemographicsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public Demographics getDemographics(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        Demographics demographics = null;
        this.setDefaultRpcName("ORWPT SELECT");
        String x = this.sCall(dfn);
        if (StringUtils.piece((String)x, (int)1).equals("-1")) {
            return null;
        }
        demographics = new Demographics();
        demographics.setDfn(dfn);
        demographics.setName(StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)1)));
        demographics.setSensitive(StringUtils.piece((String)x, (int)9).equals("1"));
        demographics.setIcn(StringUtils.piece((String)x, (int)14));
        demographics.setSsn(StringUtils.formatSSN((String)StringUtils.piece((String)x, (int)4)));
        demographics.setSex(StringUtils.piece((String)x, (int)2));
        demographics.setLocationIen(StringUtils.piece((String)x, (int)5));
        demographics.setLocation(StringUtils.piece((String)x, (int)6));
        demographics.setRoomBed(StringUtils.piece((String)x, (int)7));
        demographics.setSpecialtyIen(StringUtils.piece((String)x, (int)16));
        demographics.setCwad(StringUtils.piece((String)x, (int)8));
        demographics.setRestricted(StringUtils.piece((String)x, (int)9).equals("1"));
        demographics.setAdmitTime(FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)10), (double)0.0)));
        try {
            demographics.setAdmitTimeStr(DateUtils.toEnglishDate((Date)demographics.getAdmitTime()));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        demographics.setServiceConnected(StringUtils.piece((String)x, (int)12).equals("1"));
        demographics.setServiceConnectedPercent(StringUtils.toInt((String)StringUtils.piece((String)x, (int)13), (int)0));
        demographics.setDob(FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)3), (double)0.0)));
        try {
            demographics.setDobStr(DateUtils.toEnglishDate((Date)demographics.getDob()));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        demographics.setAge(DateUtils.calcAge((Date)demographics.getDob()));
        this.setDefaultRpcName("ORWPT DIEDON");
        x = this.sCall(dfn);
        demographics.setDeceasedDate(FMDateUtils.fmDateTimeToDate(Double.valueOf(x)));
        try {
            demographics.setDeceasedDateStr(DateUtils.toEnglishDate((Date)demographics.getDeceasedDate()));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        this.setDefaultRpcName("ORWPT1 PRCARE");
        x = this.sCall(dfn);
        demographics.setPrimaryTeam(StringUtils.piece((String)x, (int)1));
        demographics.setPrimaryProvider(StringUtils.piece((String)x, (int)2));
        if (demographics.getLocation().length() > 0) {
            demographics.setAttending(StringUtils.piece((String)x, (int)3));
        } else {
            demographics.setAttending("");
        }
        if (specialtiesMap == null) {
            specialtiesMap = new HashMap<String, Map<String, String>>();
        }
        if (!specialtiesMap.containsKey(this.getDivision())) {
            SpecialtiesTeamsDao specialtiesTeamsRpc = new SpecialtiesTeamsDao(this);
            specialtiesMap.put(this.getDivision(), specialtiesTeamsRpc.listAllSpecialtiesMap());
        }
        if (demographics.getSpecialtyIen() != null) {
            Map<String, String> map = specialtiesMap.get(this.getDivision());
            demographics.setSpecialty(map.get(demographics.getSpecialtyIen()));
        } else {
            demographics.setSpecialty("");
        }
        return demographics;
    }

    public Demographics getAlsiDemographics(String dfn) throws Exception {
        this.setDefaultContext(null);
        this.setDefaultRpcName("ALSI PATIENT SELECT");
        Demographics demographics = null;
        String x = this.sCall(dfn);
        if (StringUtils.piece((String)x, (int)1).equals("-1")) {
            return null;
        }
        demographics = new Demographics();
        demographics.setDfn(dfn);
        demographics.setName(StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)1)));
        demographics.setSensitive(StringUtils.piece((String)x, (int)9).equals("1"));
        demographics.setIcn(StringUtils.piece((String)x, (int)14));
        demographics.setSsn(StringUtils.formatSSN((String)StringUtils.piece((String)x, (int)4)));
        demographics.setSex(StringUtils.piece((String)x, (int)2));
        demographics.setLocationIen(StringUtils.piece((String)x, (int)5));
        demographics.setLocation(StringUtils.piece((String)x, (int)6));
        demographics.setRoomBed(StringUtils.piece((String)x, (int)7));
        demographics.setSpecialtyIen(StringUtils.piece((String)x, (int)16));
        demographics.setCwad(StringUtils.piece((String)x, (int)8));
        demographics.setRestricted(StringUtils.piece((String)x, (int)9).equals("1"));
        demographics.setAdmitTime(FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)10), (double)0.0)));
        try {
            demographics.setAdmitTimeStr(DateUtils.toEnglishDate((Date)demographics.getAdmitTime()));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        demographics.setServiceConnected(StringUtils.piece((String)x, (int)12).equals("1"));
        demographics.setServiceConnectedPercent(StringUtils.toInt((String)StringUtils.piece((String)x, (int)13), (int)0));
        demographics.setDob(FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)3), (double)0.0)));
        try {
            demographics.setDobStr(DateUtils.toEnglishDate((Date)demographics.getDob()));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        demographics.setAge(DateUtils.calcAge((Date)demographics.getDob()));
        demographics.setDeceasedDate(FMDateUtils.fmDateTimeToDate(Double.valueOf(StringUtils.piece((String)x, (int)19))));
        try {
            demographics.setDeceasedDateStr(DateUtils.toEnglishDate((Date)demographics.getDeceasedDate()));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        demographics.setPrimaryTeam(StringUtils.piece((String)x, (int)20));
        demographics.setPrimaryProvider(StringUtils.piece((String)x, (int)21));
        if (demographics.getLocation().length() > 0) {
            demographics.setAttending(StringUtils.piece((String)x, (int)22));
        } else {
            demographics.setAttending("");
        }
        if (demographics.getSpecialtyIen() != null) {
            demographics.setSpecialty(StringUtils.piece((String)x, (int)18));
        } else {
            demographics.setSpecialty("");
        }
        return demographics;
    }
}

