/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.dao.OrdersDao;
import gov.va.med.lom.vistabroker.patient.dao.TiuNoteDao;
import gov.va.med.lom.vistabroker.patient.data.Consult;
import gov.va.med.lom.vistabroker.patient.data.ConsultRec;
import gov.va.med.lom.vistabroker.patient.data.ConsultRequest;
import gov.va.med.lom.vistabroker.patient.data.ConsultRequestsSelection;
import gov.va.med.lom.vistabroker.patient.data.EditResubmit;
import gov.va.med.lom.vistabroker.patient.data.LockDocumentResult;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultsDao
extends BaseDao {
    public ConsultsDao() {
    }

    public ConsultsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<ConsultRequest> getDefaultConsultRequests(String dfn) throws Exception {
        ConsultRequestsSelection consultRequestsSelection = new ConsultRequestsSelection();
        consultRequestsSelection.setService("");
        consultRequestsSelection.setStartDate(null);
        consultRequestsSelection.setStopDate(null);
        return this.getConsultRequests(dfn, consultRequestsSelection);
    }

    public List<ConsultRequest> getConsultRequests(String dfn, ConsultRequestsSelection consultRequestsSelection) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        Object[] params = null;
        if (consultRequestsSelection == null) {
            consultRequestsSelection = new ConsultRequestsSelection();
        }
        double fmDate1 = 0.0;
        if (consultRequestsSelection.getStartDate() != null) {
            fmDate1 = FMDateUtils.dateToFMDate(consultRequestsSelection.getStartDate());
        }
        double fmDate2 = 0.0;
        if (consultRequestsSelection.getStopDate() != null) {
            fmDate2 = FMDateUtils.dateToFMDate(consultRequestsSelection.getStopDate());
        }
        params = fmDate1 == 0.0 && fmDate2 == 0.0 && (consultRequestsSelection.getService() == null || consultRequestsSelection.getService().equals("")) ? new Object[]{String.valueOf(dfn)} : new Object[]{String.valueOf(dfn), String.valueOf(fmDate1), String.valueOf(fmDate2), consultRequestsSelection.getService()};
        ArrayList<ConsultRequest> consultRequests = new ArrayList<ConsultRequest>();
        this.setDefaultRpcName("ORQQCN LIST");
        List<String> list = this.lCall(params);
        for (String s : list) {
            if (s.trim().length() <= 0 || StringUtils.piece((String)s, (int)2).length() <= 0) continue;
            String ien = StringUtils.piece((String)s, (int)1);
            Date dt = FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)2));
            String status = StringUtils.piece((String)s, (int)3);
            String service = StringUtils.piece((String)s, (int)4);
            String consultNumber = "Consult #: " + ien;
            String text = StringUtils.piece((String)s, (int)6) + StringUtils.piece((String)s, (int)7);
            String parentId = StringUtils.piece((String)s, (int)8);
            String type = StringUtils.piece((String)s, (int)9);
            String typeStr = null;
            char c = type.charAt(0);
            switch (c) {
                case 'C': {
                    typeStr = "Consult";
                    break;
                }
                case 'P': {
                    typeStr = "Procedure";
                    break;
                }
                case 'M': {
                    typeStr = "Procedure";
                    break;
                }
                case 'I': {
                    typeStr = "Consult - Interfacility";
                    break;
                }
                case 'R': {
                    typeStr = "Procedure - Interfacility";
                    break;
                }
                default: {
                    typeStr = "";
                }
            }
            ConsultRequest consultRequest = new ConsultRequest();
            consultRequest.setDfn(dfn);
            consultRequest.setIen(ien);
            consultRequest.setStatus(status);
            consultRequest.setDatetime(dt);
            try {
                consultRequest.setDatetimeStr(DateUtils.toEnglishDateTime((Date)dt));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            consultRequest.setService(service);
            consultRequest.setText(text);
            consultRequest.setConsultNumber(consultNumber);
            consultRequest.setParentId(parentId);
            consultRequest.setType(type);
            consultRequest.setTypeStr(typeStr);
            consultRequests.add(consultRequest);
        }
        return consultRequests;
    }

    public String getConsultDetail(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN DETAIL");
        return this.sCall(ien);
    }

    public String getMedResults(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN MED RESULTS");
        return this.sCall(ien);
    }

    public ConsultRec getConsultRec(String ien, boolean showAddenda) throws Exception {
        String x;
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN GET CONSULT");
        Object[] params = new Object[]{StringUtils.boolToStr((boolean)showAddenda, (String)"true", (String)"false")};
        List<String> list = this.lCall(params);
        ConsultRec consultRec = new ConsultRec();
        consultRec.setIen(ien);
        if (list.size() > 0 && !StringUtils.piece((String)(x = list.get(0)), (int)1).equals("-1")) {
            Date dt = FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)1), (double)0.0));
            consultRec.setEntryDate(dt);
            try {
                consultRec.setEntryDateStr(DateUtils.toEnglishDate((Date)dt));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            consultRec.setOrFileNumber(StringUtils.toInt((String)StringUtils.piece((String)x, (int)3), (int)0));
            consultRec.setPatientLocationIen(StringUtils.piece((String)x, (int)4));
            consultRec.setOrderingFacilityIen(StringUtils.piece((String)x, (int)21));
            consultRec.setForeignConsultFileNum(StringUtils.toInt((String)StringUtils.piece((String)x, (int)22), (int)0));
            consultRec.setToServiceIen(StringUtils.piece((String)x, (int)5));
            consultRec.setFromIen(StringUtils.piece((String)x, (int)6));
            dt = FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)7), (double)0.0));
            consultRec.setRequestDate(dt);
            try {
                consultRec.setRequestDateStr(DateUtils.toEnglishDate((Date)dt));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            consultRec.setConsultProcedure(StringUtils.piece((String)x, (int)8));
            consultRec.setPlaceOfConsultIen(StringUtils.piece((String)x, (int)10));
            consultRec.setAttention(StringUtils.toInt((String)StringUtils.piece((String)x, (int)11), (int)0));
            consultRec.setOrStatus(StringUtils.toInt((String)StringUtils.piece((String)x, (int)12), (int)0));
            consultRec.setLastAction(StringUtils.toInt((String)StringUtils.piece((String)x, (int)13), (int)0));
            consultRec.setSendingProviderDfn(StringUtils.piece((String)StringUtils.piece((String)x, (int)14), (char)';', (int)1));
            consultRec.setSendingProviderName(StringUtils.piece((String)StringUtils.piece((String)x, (int)14), (char)';', (int)2));
            consultRec.setResult(StringUtils.piece((String)x, (int)15));
            consultRec.setModeOfEntry(StringUtils.piece((String)x, (int)16));
            consultRec.setRequestType(StringUtils.toInt((String)StringUtils.piece((String)x, (int)17), (int)0));
            consultRec.setInOut(StringUtils.piece((String)x, (int)18));
            consultRec.setFindings(StringUtils.piece((String)x, (int)19));
            consultRec.setTiuResultNarrative(StringUtils.toInt((String)StringUtils.piece((String)x, (int)20), (int)0));
            list.remove(0);
            StringBuffer tiuDocuments = new StringBuffer();
            StringBuffer medResults = new StringBuffer();
            if (list.size() > 0) {
                StringUtils.sortByPiece(list, (int)3);
                for (int i = 0; i < list.size(); ++i) {
                    String y = list.get(i);
                    if (StringUtils.piece((String)StringUtils.piece((String)y, (int)1), (char)';', (int)2).substring(1, 5).equalsIgnoreCase("mcar")) {
                        medResults.append(y + "\n");
                        continue;
                    }
                    tiuDocuments.append(y + "\n");
                }
            }
        }
        return consultRec;
    }

    public Consult findConsult(String consultIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN FIND CONSULT");
        String x = this.sCall(consultIen);
        Consult consult = new Consult();
        consult.setIen(StringUtils.piece((String)x, (int)1));
        Date dt = FMDateUtils.fmDateTimeToDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)11), (double)0.0));
        consult.setDatetime(dt);
        try {
            consult.setDatetimeStr(DateUtils.toEnglishDate((Date)dt));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        consult.setStatus(StringUtils.piece((String)x, (int)3));
        consult.setText(StringUtils.piece((String)x, (int)4));
        consult.setNum(StringUtils.toInt((String)StringUtils.piece((String)x, (int)5), (int)0));
        consult.setOrderIfn(StringUtils.piece((String)x, (int)6));
        consult.setParentIen(StringUtils.piece((String)x, (int)8));
        char c = StringUtils.piece((String)x, (int)9).charAt(0);
        switch (c) {
            case 'C': {
                consult.setType("Consult");
                break;
            }
            case 'P': {
                consult.setType("Procedure");
                break;
            }
            case 'M': {
                consult.setType("Procedure");
                break;
            }
            case 'I': {
                consult.setType("Consult - Interfacility");
                break;
            }
            case 'R': {
                consult.setType("Procedure - Interfacility");
            }
        }
        consult.setService(StringUtils.piece((String)x, (int)10));
        return consult;
    }

    public String getConsultOrderIen(String consultIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN GET ORDER NUMBER");
        return this.sCall(consultIen);
    }

    public String getProcedureIen(String orderIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN GET PROC IEN");
        return this.sCall(orderIen);
    }

    public String getCPRequests(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("MAG4 CP GET REQUESTS");
        return this.sCall(dfn);
    }

    public String denyConsult(String orderIen, String userDuz, Date dcDate, String comments) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN DISCONTINUE");
        if (dcDate == null) {
            dcDate = new Date();
        }
        double fmDate = FMDateUtils.dateTimeToFMDateTime(dcDate);
        Object[] params = new Object[]{orderIen, userDuz, String.valueOf(fmDate), "DY", comments};
        return this.sCall(params);
    }

    public String discontinueConsult(String orderIen, String userDuz, Date dcDate, String comments) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN DISCONTINUE");
        if (dcDate == null) {
            dcDate = new Date();
        }
        double fmDate = FMDateUtils.dateTimeToFMDateTime(dcDate);
        Object[] params = new Object[]{orderIen, userDuz, String.valueOf(fmDate), "DC", comments};
        return this.sCall(params);
    }

    public String addConsultComment(String consultId, List<String> comments, boolean alert, String alertTo, double actionDate) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN ADDCMT");
        Object[] params = new Object[]{consultId, comments, "1", alertTo, actionDate};
        return this.sCall(params);
    }

    public EditResubmit loadConsultForEdit(String consultIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN LOAD FOR EDIT");
        List<String> list = this.lCall(consultIen);
        EditResubmit editRec = new EditResubmit();
        editRec.setChanged(false);
        editRec.setIen(consultIen);
        editRec.setToService(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"SERVICE"), (int)2));
        editRec.setRequestType(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"TYPE"), (int)3));
        editRec.setOrderableItem(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"PROCEDURE"), (int)1));
        editRec.setConsultProc(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"PROCEDURE"), (int)3));
        editRec.setConsultProcName(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"PROCEDURE"), (int)2));
        editRec.setUrgency(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"URGENCY"), (int)3));
        editRec.setUrgencyName(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"URGENCY"), (int)2));
        editRec.setEarliestDate(StringUtils.toDouble((String)StringUtils.piece((String)StringUtils.extractDefault(list, (String)"EARLIEST"), (int)2), (double)0.0));
        editRec.setPlace(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"PLACE"), (int)1));
        editRec.setPlaceName(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"PLACE"), (int)2));
        editRec.setAttention(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"ATTENTION"), (int)1));
        editRec.setAttentionName(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"ATTENTION"), (int)2));
        editRec.setInpOutp(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"CATEGORY"), (int)1));
        editRec.setProvDiagnosis(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"DIAGNOSIS"), (int)1));
        editRec.setProvDxCode(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"DIAGNOSIS"), (int)2));
        editRec.setProvDxCodeInactive(StringUtils.piece((String)StringUtils.extractDefault(list, (String)"DIAGNOSIS"), (int)3).equals("1"));
        editRec.setRequestReason(StringUtils.extractText(list, (String)"REASON"));
        editRec.setDenyComments(StringUtils.extractText(list, (String)"DENY COMMENT"));
        editRec.setNewComments(StringUtils.extractText(list, (String)"ADDED COMMENT"));
        return editRec;
    }

    public LockDocumentResult lockConsultRequest(String ien) throws Exception {
        String orderIen = this.getConsultOrderIen(ien);
        if (!orderIen.equals("0")) {
            OrdersDao ordersDao = new OrdersDao(this);
            return ordersDao.lockOrder(ien);
        }
        return null;
    }

    public String unlockConsult(String noteIen) throws Exception {
        TiuNoteDao tiuNoteDao = new TiuNoteDao(this);
        String consultIen = tiuNoteDao.getConsultIenforNote(noteIen);
        if (!consultIen.equals("0")) {
            OrdersDao ordersDao = new OrdersDao(this);
            String orderIen = this.getConsultOrderIen(consultIen);
            if (!orderIen.equals("0")) {
                return ordersDao.unlockOrder(orderIen);
            }
            return "";
        }
        return "";
    }
}

