/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.ClinicalReminder;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClinicalRemindersDao
extends BaseDao {
    public ClinicalRemindersDao() {
    }

    public ClinicalRemindersDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<ClinicalReminder> getClinicalReminders(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQPX REMINDERS LIST");
        ArrayList<ClinicalReminder> clinicalReminders = new ArrayList<ClinicalReminder>();
        List<String> list = this.lCall(dfn);
        for (String s : list) {
            if (s.trim().length() <= 0) continue;
            String due = StringUtils.piece((String)s, (int)3);
            if (!due.equals("DUE NOW")) {
                due = DateUtils.formatDate((Date)FMDateUtils.fmDateTimeToDate(due), (String)DateUtils.ENGLISH_DATE_FORMAT);
            }
            String occur = DateUtils.formatDate((Date)FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)4)), (String)DateUtils.ENGLISH_DATE_FORMAT);
            ClinicalReminder reminder = new ClinicalReminder();
            reminder.setDfn(dfn);
            reminder.setIen(StringUtils.piece((String)s, (int)1));
            reminder.setWhenDue(due);
            reminder.setLastOccurrence(occur);
            reminder.setName(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)));
            clinicalReminders.add(reminder);
        }
        return clinicalReminders;
    }

    public String getClinicalReminderDetails(String dfn, String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQPXRM REMINDER DETAIL");
        Object[] params = new String[]{dfn, ien};
        return this.sCall(params);
    }
}

