/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.AllergiesReactants;
import gov.va.med.lom.vistabroker.patient.data.AllergyReactant;
import java.util.ArrayList;
import java.util.List;

public class AllergiesReactantsDao
extends BaseDao {
    public AllergiesReactantsDao() {
    }

    public AllergiesReactantsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public AllergiesReactants getAllergiesReactants(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQAL LIST");
        List<String> list = this.lCall(dfn);
        AllergiesReactants allergiesReactants = new AllergiesReactants();
        if (list.size() == 1) {
            String a = StringUtils.piece((String)list.get(0), (int)2);
            if (a.equalsIgnoreCase("no known allergies")) {
                allergiesReactants.setNoKnownAllergies(true);
                list.clear();
            } else if (a.equalsIgnoreCase("no allergy assessment")) {
                allergiesReactants.setNoAllergyAssessment(true);
                list.clear();
            }
        }
        ArrayList<AllergyReactant> allergiesReactantsList = new ArrayList<AllergyReactant>();
        for (String s : list) {
            AllergyReactant allergyReactant = new AllergyReactant();
            allergyReactant.setDfn(dfn);
            allergyReactant.setIen(StringUtils.piece((String)s, (int)1));
            allergyReactant.setAllergenReactant(StringUtils.piece((String)s, (int)2));
            allergyReactant.setSeverity(StringUtils.piece((String)s, (int)3));
            String[] x = StringUtils.pieceList((String)StringUtils.piece((String)s, (int)4), (char)';');
            allergyReactant.setReactionsSymptoms(x);
            allergiesReactantsList.add(allergyReactant);
        }
        allergiesReactants.setAllergiesReactants(allergiesReactantsList);
        return allergiesReactants;
    }

    public String getAllergyDetail(String dfn, String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQAL DETAIL");
        Object[] params = new String[]{dfn, ien, ""};
        List<String> list = this.lCall(params);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s + "\n");
        }
        return sb.toString();
    }
}

