/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.dao;

import gov.va.med.exception.FoundationsException;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.exception.VistaBrokerConnectionException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerIllegalArgumentException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerInvalidResultException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerSecurityException;
import gov.va.med.lom.vistabroker.exception.VistaBrokerSocketTimeoutException;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import gov.va.med.net.VistaSocketTimeOutException;
import gov.va.med.vistalink.adapter.cci.VistaLinkAppProxyConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkCcowConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkVpidConnectionSpec;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDao {
    private String defaultContext;
    private String defaultRpcName;
    private String rpcName;
    protected ISecurityContext securityContext;
    private RpcResponse rpcResponse;
    private VistaLinkConnection conn;
    private int timeoutForCall;
    private static final Log log = LogFactory.getLog(BaseDao.class);
    private static final int DEF_REQ_TIMEOUT = 15000;
    private static String jndiPrefix;
    public static final int INVALID_SECURITY_PARAMS = 1;
    public static final int VISTALINK_FAULT_EXCEPTION = 2;
    public static final int SOCKET_TIMEOUT = 3;
    public static final int NO_MANAGED_CONNECTIONS = 4;
    public static final int VISTA_CONNECTION_ERROR = 5;
    public static final int UNDETERMINED_EXCEPTION = 6;

    public BaseDao() {
        this.defaultContext = null;
        this.defaultRpcName = null;
        this.rpcName = null;
        this.securityContext = null;
        this.conn = null;
        this.timeoutForCall = 0;
    }

    public BaseDao(BaseDao baseDao) {
        this.defaultContext = baseDao.getDefaultContext();
        this.defaultRpcName = baseDao.getDefaultRpcName();
        this.rpcName = baseDao.getRpcName();
        this.securityContext = baseDao.getSecurityContext();
        this.conn = baseDao.conn;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        if (this.defaultContext == null) {
            this.defaultContext = defaultContext;
        }
    }

    public String getDefaultRpcName() {
        return this.defaultRpcName;
    }

    public void setDefaultRpcName(String defaultRpcName) {
        this.defaultRpcName = defaultRpcName;
    }

    public String getRpcName() {
        return this.rpcName;
    }

    public void setRpcName(String rpcName) {
        this.rpcName = rpcName;
    }

    public String getDivision() {
        return this.securityContext.getDivision();
    }

    public String getUserId() {
        return this.securityContext.getUserId();
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public static Log getLog() {
        return log;
    }

    public RpcResponse getRpcResponse() {
        return this.rpcResponse;
    }

    public String getResults() {
        return this.rpcResponse.getResults();
    }

    public String getResultType() {
        return this.rpcResponse.getResultsType();
    }

    public int getTimeoutForCall() {
        return this.timeoutForCall;
    }

    public void setTimeoutForCall(int timeoutForCall) {
        this.timeoutForCall = timeoutForCall;
    }

    public Document getDocument() throws Exception {
        try {
            return this.rpcResponse.getResultsDocument();
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred getting XML document.", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (ResourceException e) {
                log.error((Object)"Error closing connection:", (Throwable)e);
            }
            finally {
                this.conn = null;
            }
        }
    }

    protected String sCall() throws VistaBrokerException {
        Object[] params = new String[]{};
        return this.sCall(params);
    }

    protected String sCall(Object param) throws VistaBrokerException {
        Object[] params = new Object[]{param};
        return this.sCall(params);
    }

    protected String sCall(Object[] params) throws VistaBrokerException {
        try {
            RpcRequest req = null;
            req = RpcRequestFactory.getRpcRequest();
            if (this.rpcName != null && this.rpcName.trim().length() > 0) {
                req.setRpcName(this.rpcName);
            } else {
                req.setRpcName(this.defaultRpcName);
            }
            if (req.getRpcName() == null) {
                throw new VistaBrokerIllegalArgumentException("rpc name not specified.");
            }
            req.clearParams();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    String type = null;
                    if (params[i] == null) {
                        params[i] = "";
                    }
                    type = params[i].getClass() == HashMap.class || params[i].getClass() == Hashtable.class || params[i].getClass() == TreeMap.class || params[i].getClass() == ArrayList.class || params[i].getClass() == HashSet.class || params[i].getClass() == TreeSet.class ? "array" : "string";
                    req.getParams().setParam(i + 1, type, params[i]);
                }
            }
            return this.sCall(req);
        }
        catch (FoundationsException e1) {
            log.error((Object)"Foundations Exception", (Throwable)e1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sCall(RpcRequest req) throws VistaBrokerException {
        int timeout = 15000;
        try {
            Object ic;
            if (this.securityContext.getRpcContext() != null) {
                req.setRpcContext(this.securityContext.getRpcContext());
            } else {
                req.setRpcContext(this.defaultContext);
            }
            if (req.getRpcContext() == null || req.getRpcContext().trim().length() == 0) {
                throw new VistaBrokerIllegalArgumentException("no rpc context identified");
            }
            String jndiName = "";
            if (this.conn == null) {
                ic = new InitialContext();
                VistaLinkCcowConnectionSpec connSpec = null;
                switch (this.securityContext.getType()) {
                    case 5: {
                        connSpec = new VistaLinkVpidConnectionSpec(this.securityContext.getDivision(), this.securityContext.getUserId());
                        break;
                    }
                    case 1: {
                        connSpec = new VistaLinkAppProxyConnectionSpec(this.securityContext.getDivision(), this.securityContext.getUserId());
                        break;
                    }
                    case 2: 
                    case 3: {
                        connSpec = new VistaLinkCcowConnectionSpec(this.securityContext.getUserId());
                        break;
                    }
                    case 4: {
                        connSpec = new VistaLinkDuzConnectionSpec(this.securityContext.getDivision(), this.securityContext.getUserId());
                    }
                }
                if (connSpec != null) {
                    try {
                        jndiName = jndiPrefix + InstitutionMappingDelegate.getJndiConnectorNameForInstitution((String)this.securityContext.getDivision());
                        VistaLinkConnectionFactory cf = (VistaLinkConnectionFactory)((InitialContext)ic).lookup(jndiName);
                        this.conn = (VistaLinkConnection)cf.getConnection((ConnectionSpec)connSpec);
                    }
                    catch (Exception e) {
                        throw new VistaBrokerConnectionException(e, 5, "Exception occurred when creating managed connection.", req.getRpcName(), req.getRpcContext(), this.securityContext.getDivision(), this.securityContext.getUserId());
                    }
                } else {
                    throw new VistaBrokerSecurityException(null, 1, "Invalid Division, DUZ, VPID, App Proxy, or CCOW handle.", req.getRpcName(), req.getRpcContext(), this.securityContext.getDivision(), this.securityContext.getUserId());
                }
            }
            if (this.timeoutForCall > 15000) {
                timeout = 0;
            } else if (this.securityContext.getSocketTimeout() > 15000) {
                timeout = this.securityContext.getSocketTimeout();
            }
            this.conn.setTimeOut(timeout);
            log.debug((Object)("connection: " + jndiName + " context: " + req.getRpcContext() + " rpc: " + req.getRpcName()));
            this.rpcResponse = this.conn.executeRPC(req);
            ic = this.rpcResponse.getResults();
            return ic;
        }
        catch (VistaSocketTimeOutException e) {
            VistaBrokerSocketTimeoutException vbe = new VistaBrokerSocketTimeoutException((Exception)((Object)e));
            vbe.setTimeout(timeout);
            throw vbe;
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
        finally {
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
        throw new VistaBrokerInvalidResultException("rpc call error.  results null. please check logs for problems");
    }

    protected List<String> lCall() throws VistaBrokerException {
        return StringUtils.getStringList((String)this.sCall());
    }

    protected List<String> lCall(Object[] params) throws VistaBrokerException {
        return StringUtils.getStringList((String)this.sCall(params));
    }

    protected List<String> lCall(Object param) throws VistaBrokerException {
        return StringUtils.getStringList((String)this.sCall(param));
    }

    protected List<String> lCall(RpcRequest req) throws VistaBrokerException {
        return StringUtils.getStringList((String)this.sCall(req));
    }

    static {
        ResourceBundle res = ResourceBundle.getBundle("vistabroker");
        jndiPrefix = res.getString("jndi.prefix");
        if (jndiPrefix == null) {
            jndiPrefix = "";
        }
    }
}

